#include <time.h>
#include "tsc_common.h"

double ASC15_TIME::year()
{
  char len[5];
  memcpy(len,a,4);
  len[4]=0x00;
  return(atof(len));
}

double ASC15_TIME::month()
{
  char len[3];
  memcpy(len,a+4,2);
  len[2]=0x00;
  return(atof(len));
}

double ASC15_TIME::day()
{
  char len[3];
  memcpy(len,a+6,2);
  len[2]=0x00;
  return(atof(len));
}

double ASC15_TIME::hh()
{
  char len[3];
  memcpy(len,a+8,2);
  len[2]=0x00;
  return(atof(len));
}

double ASC15_TIME::mm()
{
  char len[3];
  memcpy(len,a+10,2);
  len[2]=0x00;
  return(atof(len));
}

double ASC15_TIME::ss()
{
  char len[4];
  memcpy(len,a+12,3);
  len[3]=0x00;
  return(atof(len)*0.1);
}


double ASC15_TIME::HSTyear()
{
  tm o_it,o_it_HST;
  tm *it,*it_HST;
  it=&o_it;
  it_HST=&o_it_HST;
  int ret;
  ret=0;

  time_t it_t;
  
  if((day()!=0.0)&&(month()!=0.0)){ // for data missing
    it->tm_year =(int)(year()-1900.0);
    it->tm_mon  =(int)(month())-1; // c and c++ month [0..11]
    it->tm_mday =(int)(day());
    it->tm_hour =(int)(hh());
    it->tm_min  =(int)(mm());
    it->tm_sec  =(int)(floor(ss()));
    it->tm_wday =0;
    it->tm_yday =0;
    it->tm_isdst=0; // Hawaii does not use summer time
    it_t=timegm(it);
    it_HST=localtime(&it_t);
    ret=it_HST->tm_year+1900;
  }
  return((double)ret);
}

double ASC15_TIME::HSTmonth()
{
  tm o_it,o_it_HST;
  tm *it,*it_HST;
  it=&o_it;
  it_HST=&o_it_HST;

  time_t it_t;
  int ret;
  ret=0;
  if((day()!=0.0)&&(month()!=0.0)){ // for data missing
    it->tm_year =(int)(year()-1900.0);
    it->tm_mon  =(int)(month())-1; // c and c++ month [0..11]
    it->tm_mday =(int)(day());
    it->tm_hour =(int)(hh());
    it->tm_min  =(int)(mm());
    it->tm_sec  =(int)(floor(ss()));
    it->tm_wday =0;
    it->tm_yday =0;
    it->tm_isdst=0; // Hawaii does not use summer time
    it_t=timegm(it);
    it_HST=localtime(&it_t);
    ret=it_HST->tm_mon+1;
  }
  return((double)ret);
}

double ASC15_TIME::HSTday()
{
  tm o_it,o_it_HST;
  tm *it,*it_HST;
  it=&o_it;
  it_HST=&o_it_HST;

  time_t it_t;
  int ret;
  ret=0;
  if((day()!=0.0)&&(month()!=0.0)){ // for data missing
    it->tm_year =(int)(year()-1900.0);
    it->tm_mon  =(int)(month())-1; // c and c++ month [0..11]
    it->tm_mday =(int)(day());
    it->tm_hour =(int)(hh());
    it->tm_min  =(int)(mm());
    it->tm_sec  =(int)(floor(ss()));
    it->tm_wday =0;
    it->tm_yday =0;
    it->tm_isdst=0; // Hawaii does not use summer time
    it_t=timegm(it);
    it_HST=localtime(&it_t);
    ret=it_HST->tm_mday;
  }
  return((double)ret);
}

double ASC15_TIME::HSThh()
{
  tm o_it,o_it_HST;
  tm *it,*it_HST;
  it=&o_it;
  it_HST=&o_it_HST;

  time_t it_t;
  int ret;
  ret=0;
  if((day()!=0.0)&&(month()!=0.0)){ // for data missing
    it->tm_year =(int)(year()-1900.0);
    it->tm_mon  =(int)(month())-1; // c and c++ month [0..11]
    it->tm_mday =(int)(day());
    it->tm_hour =(int)(hh());
    it->tm_min  =(int)(mm());
    it->tm_sec  =(int)(floor(ss()));
    it->tm_wday =0;
    it->tm_yday =0;
    it->tm_isdst=0; // Hawaii does not use summer time
    it_t=timegm(it);
    it_HST=localtime(&it_t);
    ret=it_HST->tm_hour;
  }
  return((double)ret);
}
