/* example.c: an example to extract telescope status on TWS4 */
/*

Copyright (C) 2010 by Daigo Tomono <tomono at subaru.naoj.org>

Permission is granted for use, copying, modification, distribution,
and distribution of modified versions of this work under the terms of
GPL version 2 or later.

Build with command like:
gcc -o example -ltscstatus -ltscstatus-shm example.c 

*/
#include <stdio.h>
#include <stdlib.h>
#include <malloc.h>
#include <time.h>
#include <assert.h>

#include <melco/tsc-message.h>
#include <melco/shm-interface.h>

void print_ra(void);
void print_pointing(void);

void
print_ra(void)
{
	StatusEntry *ra;
	char *buf;
	int len;
	time_t time;

	/*
		Look into a status entry by its name defined by Mitsubishi:
		/usr/local/share/doc/tsc-status/status-entries.txt
	*/
	ra = shm_get_status_entry("Right Ascention");
	assert(ra);

	/* Obtain a string expression */
	len = StatusEntry_to_s_length(ra);
	buf = (char *) malloc(len);
	assert(buf);
	StatusEntry_to_s(ra, buf);
	fprintf(stdout, "RA:%s\n", buf);

	/* Obtain time stamp */
	StatusEntry_rxtime(ra, &time);
	fprintf(stdout, "Status is received at %s", ctime(&time));
}

void
print_pointing(void)
{
	StatusEntry *pointing;
	long long flag;
	
	pointing = shm_get_status_entry("Telescope Pointing");
	assert(pointing);

	/* Obtain a flag - or anything else as an integer */
	StatusEntry_to_i(pointing, &flag);
	if (flag)
		fputs("Telescope is pointing\n", stdout);
	else
		fputs("Telescope is not pointing\n", stdout);
}

int
main(int argc, char *argv[])
{
	print_ra();
	print_pointing();
	return EXIT_SUCCESS;
}
