#!/usr/bin/ruby
# usage: ruby login-from-name.rb name TSCV*-E-00A1.log

name = ARGV.shift

ARGV.each do |logfile|
	unless '-' == logfile then
		f = File.open( logfile )
	else
		f = $stdin
	end

	stat_col = Hash.new
	name_col = Hash.new
	comp_col = Hash.new
	rem = f.gets.chomp.sub( /#/, '' ).split( /\t/ )
	rem.map{ |x| /\ATSC Process (Login\d+)\Z/ =~ x && $1 }.compact.each do |key|
		stat_col[key] = rem.index( "TSC Process #{key}" )
		name_col[key] = rem.index( "TSC #{key} Login Name" )
		comp_col[key] = rem.index( "TSC #{key} Computer" )
	end
	 
	puts "#" + [ rem[0..2], "number-of-logins", "from:as ..." ].join( "\t" )
	prev_logins = Array.new
	f.each do |line|
		next if line =~ /^#/
		cs = line.chomp.split( /\t/ ).map{ |x| x.strip }
		logins = Array.new
		name_col.each_pair do |key, col|
			logins << "#{cs[comp_col[key]]}:#{key}" if name == cs[col] and '1' == cs[stat_col[key]]
		end
		puts [ cs[0..2], logins.length, logins ].join( "\t" ) if prev_logins != logins
		prev_logins = logins
	end

	unless '-' == logfile then
		f.close
	end
end
