#!/usr/local/bin/python

import sys
import tel
import shm
import time
import commands
import string
import urllib
import dewpt


############################### C O N S T A N T S ###############################
ERR="ERROR - "
WRNG="WARNING -"
BELL="\a\a\a\a\a\a\a"
ALM_ON=[1,1,1,1,1, 1,1,1,1,1, 1,1,1,1,1, 1,1,1,1,1, 1,1,1,1,1, 1,1,1,1,1, 1,1,1,1,1, 1,1,1,1,1]
DEBUG = False
# LTCS Constants -- CHANGE HERE
SLEW_PCT = 0.035945
SCAM_AZ_SLEWRATE = 0.5564 * SLEW_PCT
SCAM_EL_SLEWRATE = 0.5564 * SLEW_PCT
LTCSURL = 'http://ltcs.naoj.hawaii.edu:8011/ltcs.html/'
LTCSSTRG = "TIMESTAMP1"
RADiffLim = 0.002
DECDiffLim = 0.002
ZENITH = 89.85
YESINDEX = 313



locTime=""
oldtimestamp = -10000000


def printUsage() :
    print
    print
    print "USAGE: ./SysChkr.py"
    print "or     ./SysChkr.py -[h|H]"
    print "or     ./SysChkr.py -[s|S] [DISABLE_STRING]"
    print
    print "OPTIONS"
    print "     -h or -H   prints this help and exits."
    print "     -s or -S   silence alarm(s) for items specified in the DISABLE_STRING."
    print
    print "DISABLE_STRING"
    print "     string of numbers corresponding to the number to the left of the alarm"
    print "     that is to be silenced.  More than one alarm can be silence by separating the"
    print "     numbers by commas."
    print
    print "     e.g. ./SysChkr.py -s  0,3,10"
    print
    print "     would result in item zero (EL Drive), third item (Dome Drive), seventh item"
    print "     (IRM2 Tip/Tilt) to have their respective alarms silenced."
    print

# Checking to see that this is the first instance of this Python script running.
#print commands.getoutput('ps -e | grep SysChkr | wc -l | cut -c 7-9' )
#numInst = commands.getoutput('ps -e | grep SysChkr | wc -l | cut -c 7-9')
#if numInst[0] != '1' :
#    print "SysChkr.py: Another SysChkr1py Python script is currently running."
#    print "SysChkr.py: Only one SysChkr.py is allowed to run at any given time."
#    print "SysChkr.py: Kill the currently running SysChkr.py script before starting again."
#    sys.exit(0)
def setAlmOff(idx) :
    
    global ALM_ON
    
    if idx > -1 and idx < len(ALM_ON) :
        ALM_ON[idx] = 0


     
# A function to parse -s/S (silence alarm) into tokens and then validate the
# tokens into valid index entries into the ALM_ON alarm list.
# Input:  inStr - input string containing indices into DISABLE_MODE string.
# Returns: 1 (check was successful)/
def parseSilStr(inStr) :

    strLen = len(inStr)
    aIStr = ""
    almIdx = -1

#    print inStr+" len = %d" %strLen
    idx = 0
    while idx < strLen :
        if inStr[idx].isdigit() == True :
#            print "inStr[%d] = %s is a digit" %(idx, inStr[idx])
            aIStr = aIStr + inStr[idx]
#            print "aIStr = " + aIStr
            almIdx = int(aIStr)
#            print "almIdx = %d" %almIdx
        elif inStr[idx] == "," :
#            print "inStr[%d] = %s is a comma" %(idx, inStr[idx])
            if len(aIStr) > 0 :
                almIdx = int(aIStr)
            aIStr = ""
#            print "almIdx = %d" %almIdx
            setAlmOff(almIdx)
            almIdx = -1
        else :
            print ERR+"invalid alphabetic character in alarm silence field."
            sys.exit(0)
        idx = idx + 1

    # Set the ALM_ON list for the last index which is not delimited by a comma.
    setAlmOff(almIdx)
    


# Checking for command line parameters.
if len(sys.argv) > 1 :
    if sys.argv[1] == "-h" or sys.argv[1] == "-H" :
        printUsage()
        sys.exit(0)
    elif sys.argv[1] == "-s" or sys.argv[1] == "-S" :
         if len(sys.argv) > 2 :
             DISABLE_STRING = sys.argv[2]
#             print "DISABLE_STRING = " + DISABLE_STRING
             parseSilStr(DISABLE_STRING)
         else :
             print ERR+"Missing silence alarm field"
             sys.exit(0)
    else :
        print "SysChkr.py : Invalid option %s selected." %sys.argv[1]
        printUsage()
        sys.exit(0)


# Setting up shared memory for type short
ms = shm.memory(shm.getshmid(0x100));
tscs=tel.TSCShort();
ms.attach(); 


# Setting up shared memory for type long
ml = shm.memory(shm.getshmid(0x101));
tscl=tel.TSCLong();
ml.attach();


# Setting up shared memory for type vstat
mv = shm.memory(shm.getshmid(0x102));
tscv=tel.TSCVstat();
mv.attach(); 


# Initial read of shared memory from TSC
tscs.set(ms.read(1292))
tscl.set(ml.read(1292*7))
tscv.vset(mv.read(12931))


# Check if Vstat connection between TSC-TWS4 is working.
print "Checking Vstat TSC-TWS4 connection."
prev_ss = tscv.time0000.ss()
t_cnt = 0
ss = prev_ss
# 600 iterations * 0.2 sec = 120 second timeout period.
while (ss == prev_ss and t_cnt < 600) :
    tscv.vset(mv.read(12391))
    prev_ss = ss
    ss = tscv.time0000.ss()
    t_cnt = t_cnt + 1
    if (ss == prev_ss) :
        time.sleep(0.2)
if (ss == prev_ss) :
    print ERR+"Vstat timestamp is not updating.  ABORTING!" 
    print "At the command prompt, type the following: /home/naoj/bin/after_reboot_tsc"
    print "Then re-run this script."
    sys.exit()  # Aborting program.


# ANSI Color Codes for terminals.
#print '\x1b[1;32m%s\x1b[0m'% ('I am bold green')
#print '\x1b[1;31m%s\x1b[0m'% ('I am bold red')
#print '\x1b[4;31m%s\x1b[0m'% ('I am underlined red')
print '\x1b[1;33m%s\x1b[0m'% ('I am bold yellow')
#print '\x1b[1;4;31m%s\x1b[0m'% ('I am bold underlined red')
#print '\x1b[7;31m%s\x1b[0m'% ('I am reverse red')
print '\x1b[6;31m%s\x1b[0m'% ('I am fast blinking reverse red')
#print '\x1b[1;41m%s\x1b[0m'% ('I am bold white on red background')
#print '\x1b[5;1;41m%s\x1b[0m'% ('I am blinking bold white on red bkgd.')


# TSC V variable checking function
# Input:  prefText - prefix text string to report.
#         tscvName - Name of tscv variable i.e. tscv.Dome_Drive_Off
#         state - Correct State 1 (True) 0 (False)
#         goodSufText - good suffix text string to report.
#         badSufText - bad suffix text string to report.
#         idx - index into DISABLE_MODE string
# Returns: 1 (check was successful)
def vcheck(prefText, tscvName, state, goodSufText, badSufText, disable, idx) :

    idxStr = "%d: " %idx
    idxStr = string.rjust(idxStr, 4)

    if tscvName == state :
        if disable == 0 :
            print idxStr+prefText+" \x1b[1;32m %s\x1b[0m" %goodSufText
        else:
            print idxStr+prefText+" \x1b[1;34m %s\x1b[0m" %goodSufText
    else:
        if disable == 0 :
            print "\x1b[1;41m"+idxStr+prefText+"  %s\x1b[0m%s" %(badSufText, BELL)
        else:
            print idxStr+prefText+" \x1b[1;34m %s\x1b[0m" %badSufText
    return 1



# Item checking function for v variables
#         Determines if item should be checked or not depending upon
#         char [d|D] in DISABLE_MODE string
# Input:  prefText - prefix text string to report.
#         tscvName - Name of tscv variable i.e. tscv.Dome_Drive_Off
#         state - Correct State 1 (True) 0 (False)
#         goodSufText - good suffix text string to report.
#         badSufText - bad suffix text string to report.
#         idx - index into DISABLE_MODE string
# Returns: 1 (check was successful)/
def setCheck(prefText, tscvName, state, goodSufText, badSufText, idx) :

    if ALM_ON[idx] == 0 :
        vcheck(prefText, tscvName, state, goodSufText, badSufText, 1, idx) 
    else :
        vcheck(prefText, tscvName, state, goodSufText, badSufText, 0, idx)
    return 1



# TSC L variable checking function
# Input:  prefText - prefix text string to print out.
#         tsclName - Name of tscv variable i.e. tscl.Weather_Humidity.val()
#         value - desired value
#         error - acceptable error (+/- error)
#         sufText - suffix text string to print out.
#         idx - index into DISABLE MODE string
# Returns: 1 (check was successful)
def lcheck(prefText, tsclName, value, error, sufText, idx) :

    lowValue = value - error
    hiValue = value + error
    tscValue = tsclName

    strVal = "%7.4f" %tscValue
    strVal = string.rjust(strVal, 5)
    idxStr = "%d: " %idx
    idxStr = string.rjust(idxStr, 4)
    
    if tscValue > lowValue and tscValue < hiValue :
        print idxStr+prefText+"\x1b[1;32m  %s%s\x1b[0m" %(strVal, sufText)
    else:
#        print "\x1b[1;41m"+idxStr+prefText+"  %s%s%s\x1b[0m" %(strVal, sufText, BELL )
         print "\x1b[5;1;41m" + idxStr+prefText+"  %s%s%s\x1b[0m" %(strVal, sufText, BELL )
    return 1



# Item checking function for long variables.
#         Determines if item should be checked or not depending upon
#         char [d|D] in DISABLE_MODE string
# Input:  prefText - prefix text string to report.
#         tsclName - Name of tscl variable i.e. tscl.Heat_Exh_TLSCP_Coolant_Temp.val(
#         value - desired value
#         error - acceptable error (+/- error)
#         sufText - suffix text string to print out.
#         idx - index into DISABLE_MODE string
# Returns: 1 (check was successful)/
def longCheck(prefText, tsclName, value, error, SufText, idx) :

    strVal = "%7.4f" %tsclName
    strVal = string.rjust(strVal, 5)
    idxStr = "%d: " %idx
    idxStr = string.rjust(idxStr, 4)
    
    if ALM_ON[idx] == 0 :
        print idxStr+prefText+"\x1b[1;34m  %s%s\x1b[0m" %(strVal,SufText)
    else :
        lcheck(prefText, tsclName, value, error, SufText, idx);
    return 1



# TSC S (Short) variable checking function
# Input:  prefText - prefix text string to print out.
#         tsclName - Name of tscv variable i.e. tscl.Weather_Humidity.val()
#         value - desired value
#         error - acceptable error (+/- error)
#         sufText - suffix text string to print out.
# Returns: 1 (check was successful)
def scheck(prefText, tscsName, value, error, sufText, idx) :

    lowValue = value - error
    hiValue = value + error
    tscValue = tscsName

    strVal = "%5.2f" %tscValue
    strVal = string.rjust(strVal, 5)
    idxStr = "%d: " %idx
    idxStr = string.rjust(idxStr, 4)
    
    if tscValue > lowValue and tscValue < hiValue :
        print idxStr+prefText+"\x1b[1;32m  %s%s\x1b[0m" %(strVal, sufText)
    else:
#        print "\x1b[1;41m"+idxStr+prefText+"  %s%s%s\x1b[0m" %(strVal, sufText, BELL )
         print "\x1b[5;1;41m" + idxStr+prefText+"  %s%s%s\x1b[0m" %(strVal, sufText, BELL )
    return 1



# Item checking function for short variables.
#         Determines if item should be checked or not depending upon
#         char [d|D] in DISABLE_MODE string
# Input:  prefText - prefix text string to report.
#         tscsName - Name of tscs variable i.e. tscs.Tip_Tilt_X_Real_Angle.val()
#         value - desired value
#         error - acceptable error (+/- error)
#         sufText - suffix text string to print out.
#         idx - index into DISABLE_MODE string
# Returns: 1 (check was successful)/
def shortCheck(prefText, tscsName, value, error, SufText, idx, cautionFlg) :

    strVal = "%5.2f" %tscsName
    strVal = string.rjust(strVal, 5)
    idxStr = "%d: " %idx
    idxStr = string.rjust(idxStr, 4)
    
    if ALM_ON[idx] == 0 :
        print idxStr+prefText+"\x1b[1;34m  %s%s\x1b[0m" %(strVal,SufText)
    elif cautionFlg :
        print idxStr+prefText+"\x1b[1;33m  %s%s\x1b[0m" %(strVal,SufText)
    else : 
        scheck(prefText, tscsName, value, error, SufText, idx);
    return 1    # end of shortCheck #



# Function to check if dome shutters are closed.
# Input:  none
# Returns: tuple (1 OPT&IR shutters are closed; 0 otherwise)
def isDomeShuttersClosed(textStr) :

    closedShutFlg = 1
    
    # Dome Shutters Closed Checking
    if tscv.Opt_Shutter_Full_Close == 0 :
        closedShutFlg = 0
        textStrg = textStr + "OP"
    if tscv.IR_Shutter_Full_Close == 0 :
        closedShutFlg = 0
        textStrg = textStr + "IR"

    return closedShutFlg, textStr   # end of isDomeShuttersClosed #



# Function to check if dome is closed.
# Input:  none
# Returns: tuple (1 dome is closed; 0 otherwise), open shutters and ventilators
def isDomeClosed() :

    closedFlag = 1
    ventStrg = ""

    # Dome Shutters Closed Checking
    ###if tscv.Opt_Shutter_Full_Close == 0 :
    ###    closedFlag = 0
    ###    ventStrg = ventStrg + "OP"
    ###if tscv.IR_Shutter_Full_Close == 0 :
    ###    closedFlag = 0
    ###    ventStrg = ventStrg + "IR"
    closedFlag, ventStrg = isDomeShuttersClosed(ventStrg)
    
    # Front & Rear Ventilators Checking
    if tscv.Front_V_Full_Close == 0 :
        closedFlag = 0
        ventStrg = ventStrg + "F1"
    if tscv.Rear_V_R1_Full_Close == 0 :
        closedFlag = 0
        ventStrg = ventStrg + "R1"
    if tscv.Rear_V_R2_Full_Close == 0 :
        closedFlag = 0
        ventStrg = ventStrg + "R2"
    if tscv.Rear_V_R3_Full_Close == 0 :
        closedFlag = 0
        ventStrg = ventStrg + "R3"
    if tscv.Rear_V_R4_Full_Close == 0 :
        closedFlag = 0
        ventStrg = ventStrg + "R4"
        
    # Side "A" Ventilators Checking
    if tscv.Side_V_A1_Full_Close == 0 :
        closedFlag = 0
        ventStrg = ventStrg + "A1"
    if tscv.Side_V_A2_Full_Close == 0 :
        closedFlag = 0
        ventStrg = ventStrg + "A2"
    if tscv.Side_V_A3_Full_Close == 0 :
        closedFlag = 0
        ventStrg = ventStrg + "A3"
    if tscv.Side_V_A4_Full_Close == 0 :
        closedFlag = 0
        ventStrg = ventStrg + "A4"

    # Side "B" Ventilators Checking
    if tscv.Side_V_B1_Full_Close == 0 :
        closedFlag = 0
        ventStrg = ventStrg + "B1"
    if tscv.Side_V_B2_Full_Close == 0 :
        closedFlag = 0
        ventStrg = ventStrg + "B2"
    if tscv.Side_V_B3_Full_Close == 0 :
        closedFlag = 0
        ventStrg = ventStrg + "B3"
    if tscv.Side_V_B4_Full_Close == 0 :
        closedFlag = 0
        ventStrg = ventStrg + "B4"

    # Side "C" Ventilators Checking
    if tscv.Side_V_C1_Full_Close == 0 :
        closedFlag = 0
        ventStrg = ventStrg + "C1"
    if tscv.Side_V_C2_Full_Close == 0 :
        closedFlag = 0
        ventStrg = ventStrg + "C2"
    if tscv.Side_V_C3_Full_Close == 0 :
        closedFlag = 0
        ventStrg = ventStrg + "C3"
    if tscv.Side_V_C4_Full_Close == 0 :
        closedFlag = 0
        ventStrg = ventStrg + "C4"

    # Side "D" Ventilators Checking
    if tscv.Side_V_D1_Full_Close == 0 :
        closedFlag = 0
        ventStrg = ventStrg + "D1"
    if tscv.Side_V_D2_Full_Close == 0 :
        closedFlag = 0
        ventStrg = ventStrg + "D2"
    if tscv.Side_V_D3_Full_Close == 0 :
        closedFlag = 0
        ventStrg = ventStrg + "D3"
    if tscv.Side_V_D4_Full_Close == 0 :
        closedFlag = 0
        ventStrg = ventStrg + "D4"

    return closedFlag, ventStrg   # end of isDomeClosed #



# Function to check if dome flat lamps are on.
# Input:  none
# Returns: 1 if any dome flat lamp is on. 0 otherwise
def domeFlatLampOn() :

    lampOn = 0
    if tscv.Lamp_1_A_2_A_3_A_4_A_Light_On == 1 :
        lampOn = 1
    elif tscv.Lamp_1_B_Light_On == 1 :
        lampOn = 1 
    elif tscv.Lamp_2_B_Light_On == 1 :
        lampOn = 1
    elif tscv.Lamp_3_B_Light_On == 1 :
        lampOn = 1
    elif tscv.Lamp_4_B_Light_On == 1 :
        lampOn =1

    return lampOn   # end of domeFlatLampOn #



# Function to check if telescope is slewing in AZ or EL.
# Input:  none
# Returns: 1 telescope is slewing. 0 otherwise
def isTelSlewing() :

    slewFlg = True
    azSlewFlg = True
    elSlewFlg = True
    
    if tscl.AZ_Rate_REF.val() > -SCAM_AZ_SLEWRATE and tscl.AZ_Rate_REF.val() < SCAM_AZ_SLEWRATE :
        if DEBUG :
            print "AZ NOT SLEWING at ", tscl.AZ_Rate_REF.val()
        azSlewFlg = False


    if tscl.EL_Rate_REF.val() > -SCAM_EL_SLEWRATE and tscl.EL_Rate_REF.val() < SCAM_EL_SLEWRATE :
        if DEBUG :
            print "EL NOT SLEWING at ", tscl.EL_Rate_REF.val()
        elSlewFlg = False

    if not azSlewFlg and not elSlewFlg :
        slewFlg = False

    if not tscv.Mount_Auto_Guiding_Mode and not tscv.Mount_Pointing_Mode and not tscv.Mount_Open_Tracking_Mode :
        slewFlg = True

    return slewFlg   # end of isTelSlewing #
  


# Function to if Subaru LTCS webpage is operating correctly: timestamp updating and LASER_IMPACTED
# Input: oldtimestamp - value of the previously recorded timestamp
#        errNoTime - Line number used by SysChkr.py for LTCS timestamp checking
#        errNoImpact - Line number used by SysChkr.py for LTCS laser impacted checking.
# Returns: 1 if LTCS is operating normally. 0 otherwise
def isLTCSOK(oldTimeStp, errNoTime, errLaserOn, errNoImpact) :
    
    try:
        urlResp = urllib.urlopen(LTCSURL)     
    except IOError, e:
        setCheck("LTCS Timestamp1    ", 1, 0, "NoURL", "NoURL", errNoTime)
        setCheck("LTCS Laser_Impacted", 1, 0, "NoURL", "NoURL", errNoImpact)       
        if DEBUG :
            print "isLTCSOK: Unable to connect to LTCS web page.",e
    else:
         
        # Get tel. status information even before reading the LASER_IMPACTED flag to
        # allow for time delay when LASER_IMPACTED goes from "NO" to "YES".
        errStr = ""
        if isTelSlewing() :
            errStr = errStr + "Slw"
            isLasImpFlgOK = True
            telSlewFlg = True
        else :
            isLasImpFlgOK = False
            telSlewFlg = False
        domeClosed, junk = isDomeShuttersClosed('')
        ###print "junk = ", junk, "  domeClosed = ", domeClosed
        if domeClosed :
            errStr = errStr + "Cld"
            isLasImpFlgOK = True
        if tscs.EL_Real_Angle.val() > ZENITH :
            errStr = errStr + "Zen"
            isLasImpFlgOK = True
        rgtAshh = tscs.Right_Ascention.hh()
        rgtAsmm = tscs.Right_Ascention.mm() / 60.00
        rgtAsss = tscs.Right_Ascention.ss() / 3600.00
        rgtAs = rgtAshh + rgtAsmm + rgtAsss
        declindd = tscs.Declination.dd()
        declinmm = tscs.Declination.mm() / 60.00
        declinss = tscs.Declination.ss() / 3600.00
        declin = declindd + declinmm + declinss
        if '-' in tscs.Declination.char_flag() :
            declin = declin * -1.00

        # Delay reading to allow LASER_IMPACT flag to change when slowing down from a slew.
        time.sleep(0.5)
        
        headers = urlResp.info()
        
        data = urlResp.read()

        if DEBUG :
            print 'isLTCSOK'
            print 'URL     :', urlResp.geturl()
            print 'DATE    :', headers['date']
            print 'HEADERS :'
            print '---------'
            print headers
            print 'LENGTH  :', len(data)
            print 'DATA    :'
            print '---------'
            print data

        # Timestamp update checking.
        timeIdx = data.find(LTCSSTRG)
        if timeIdx > -1 :
            newTimeStp = data[timeIdx+16:timeIdx+26]
            if DEBUG :
                print 'TIMESTAMP1 index: ', timeIdx
                print 'isLTCSOK: new = ',newTimeStp, " old = ", oldTimeStp
      
            if (newTimeStp == oldTimeStp or not newTimeStp.isdigit()) :
                if DEBUG :
                    print "isLTCSOK: TIMESTAMP: BAD"
                tmStpOK = 0
            else :
                if DEBUG :
                    print "isLTCSOK: TIMESTAMP: OK "
                tmStpOK = 1
        else :
            newTimeStp = oldTimeStp
            if DEBUG :
                print 'isLTCSOK: Cannot find timestamp data.'
            tmStpOK = 0
        setCheck("LTCS Timestamp1    ", tmStpOK, 1, "OK ", "BAD", errNoTime)                
        oldTimeStp = newTimeStp

        # Subaru LASER_STATE Flag checking
        isLasOn = -1
        lasOnIdx = data.find("LASER_STATE")
        if lasOnIdx > -1 :
            lasOnStr = data[lasOnIdx+16:lasOnIdx+19]
            if "ON" in lasOnStr :
                errStr = errStr + "Las"
                isLasOn = 1
                isLasImpFlgOK = 1
                if DEBUG :
                    print 'LASER_STATE: ', lasOnStr, '   lasOnIdx: ', lasOnIdx        
            else :
                isLasOn = 0
                if DEBUG :
                    print 'LASER_STATE: ', lasOnStr, '   lasOnIdx: ', lasOnIdx
        if isLasOn == -1 :
            setCheck("LTCS Laser_State   ", isLasOn, 0, "UNK", "UNK", errLaserOn)
        else :
            setCheck("LTCS Laser_State   ", isLasOn, 0, "OFF", "ON ", errLaserOn)
                
        # Checking LASER_IMPACTED Flag 
        if data.find("YES") <> YESINDEX :
            if DEBUG :
                print 'isLTCSOK: isLasImpFlgOK = ',isLasImpFlgOK, '  (',errStr,')'            
            setCheck("LTCS Laser_Impacted", isLasImpFlgOK, 1, errStr, "NO?", errNoImpact)

        else :
            isLasImpFlgOK = 1
            if DEBUG :
                print 'isLTCSOK: LASER_IMPACTED: YES (OK)'
            setCheck("LTCS Laser_Impacted", isLasImpFlgOK, 1, "YES", "???", errNoImpact)

        # Checking RA difference between LTCS and TSC
        RAIdx = data.find("RA")
        RAStr = data[RAIdx+16:RAIdx+23]
        RAFlt = float(RAStr)
        RADiff =  abs(rgtAs - RAFlt)
        # Disable RA checking if telescope is slewing
        ###if isTelSlewing() :
        ###    ALM_ON[34] = 0
        ###else :
        ###    ALM_ON[34] = 1
        if telSlewFlg :
            shortCheck("LTCS-TCS RA Err  ", RADiff*3600.00, 0.0, RADiffLim*3600.00*10000.00, "as",34, True)
        else : 
            shortCheck("LTCS-TCS RA Err  ", RADiff*3600.00, 0.0, RADiffLim*3600.00, "as",34, False)
        if DEBUG :
            print "RA index = ", RAIdx, "  TSC-RA = ", rgtAs, "  LTCS-RA = ", RAFlt
            print "RADiff = ", RADiff, "RADiffLim*3600.00*10000.00 = ", RADiffLim*3600.00*10000.00
            if RADiff > RADiffLim :
                print "LTCS RA and TSC RA differ by more than %4.2f", RADiff * 3600.00, " arcsec"

        # Checking DEC difference between LTCS and TSC
        DECIdx = data.find("DEC")
        DECStr = data[DECIdx+16:DECIdx+23]
        DECFlt = float(DECStr)
        DECDiff = abs(declin - DECFlt)
        # Disable DEC error checking if telescope is slewing.
        ###if isTelSlewing() :
        ###    ALM_ON[35] = 0
        ###else :
        ###    ALM_ON[35] = 1
        if telSlewFlg :
            shortCheck("LTCS-TCS DEC Err ", DECDiff*3600.00, 0.0, DECDiffLim*3600.00*10000.00, "as",35, True)            
        else : 
            shortCheck("LTCS-TCS DEC Err ", DECDiff*3600.00, 0.0, DECDiffLim*3600.00, "as",35, False)
        if DEBUG :
            print "DEC index = ", DECIdx,"  TSC-DEC = ", declin, "  LTCS-DEC = ", DECFlt
            print "DECDiff = ", DECDiff, "DecDiffLim*3600.00*10000.00 = ", DECDiffLim*3600.00*10000.00
            if  DECDiff > DECDiffLim :
                print "LTCS DEC and Telescope DEC differ by more than %4.2f", DECDiff * 3600, " arcsec."
                
    return oldTimeStp   # end of isLTCSOK #



print
print "Ringing the bell.  Adjust volume so that bell is audible" +  BELL
print "Control-C to quit this program."
print "** Results not valid if TSC is rebooted after this script has started!"
print
time.sleep(2)


while True :
    # Get latest data from tscv shared memory.
    tscv.vset(mv.read(12931))

    # Get latest data from tscs shared memory
    tscs.set(ms.read(1292))
    
    # Get latest data from tscl shared memory
    tscl.set(ml.read(1292*7))
    
    # Get and format the timestamp for this computer not TSC timestamp.
    locTime = time.strftime("%d%b%Y %H:%M:%S ", time.localtime())
    print locTime

    # When adding items to be monitored don't forget to add the index as the last entry in setCheck or
    # longCheck.  Also, add a "1" to the ALM_ON list for each item added.
    setCheck("EL Drive           ",tscv.EL_Drive_On, 1, "ON", "OFF",0)
    setCheck("AZ Drive           ",tscv.AZ_Drive_On, 1, "ON", "OFF",1)
    setCheck("Dome_AZ Remote     ",tscv.Dome_AZ_Remote_TSC_SYNC, 1, "SYNC", "ASYNC",2)
    setCheck("Dome Drive         ",tscv.Dome_Drive_On, 1, "ON", "OFF",3)
    setCheck("Mirror Sup. Normal ",tscv.Mirror_Support_Normal_Mode, 1, "ON", "OFF",4)
    setCheck("IEC Correction     ",tscv.IEC_Correct_On, 1, "ON", "OFF",5)
    setCheck("A40 Correction     ",tscv.A40_Correct_On, 1, "ON", "OFF",6)
    setCheck("SM Auto Foc Adj    ",tscv.SM_Auto_Focus_Adjustment_On, 1, "ON", "OFF",7)
    setCheck("2nd Mirror EL      ",tscv._2nd_Mirror_EL_SYNC, 1, "SYNC", "ASYNC",8)
    setCheck("SP_Drive_On        ",tscv.SP_Drive_On, 1, "ON", "OFF",9)

    # Tip-Tilt Mirror Checking
    if tscv.Top_Unit_Code_SMCU.a[0] == '\x03' :
        setCheck("IRM2 Tip/Tilt      ",tscv.Tip_Tilt_Drive_On, 1, "ON", "OFF",10)
        if tscv.Chopping_Start == 1 :
               shortCheck("Tip_Tilt Theta X ", tscs.Tip_Tilt_X_Real_Angle.val(), 0.0, 0.25, "", 11, True)
               shortCheck("Tip_Tilt Theta Y ", tscs.Tip_Tilt_Y_Real_Angle.val(), 0.0, 0.25, "", 12, True)
               shortCheck("Tip_Tilt Z(SM)Pos", tscs.Tip_Tilt_Z_SM_Real_Position.val(), 0.0, 0.05, "mm", 13, True)
               shortCheck("Tip_Tilt Z(RC)Pos", tscs.Tip_Tilt_Z_RC_Real_Position.val(), 0.0, 0.05, "mm", 14, True) 
        else :
            shortCheck("Tip_Tilt Theta X ", tscs.Tip_Tilt_X_Real_Angle.val(), 0.0, 0.25, "", 11, False)
            shortCheck("Tip_Tilt Theta Y ", tscs.Tip_Tilt_Y_Real_Angle.val(), 0.0, 0.25, "", 12, False)
            shortCheck("Tip_Tilt Z(SM)Pos", tscs.Tip_Tilt_Z_SM_Real_Position.val(), 0.0, 0.05, "mm", 13, False)
            shortCheck("Tip_Tilt Z(RC)Pos", tscs.Tip_Tilt_Z_RC_Real_Position.val(), 0.0, 0.05, "mm", 14, False) 
    else :
        ALM_ON[10] = 0
        ALM_ON[11] = 0
        ALM_ON[12] = 0
        ALM_ON[13] = 0
        ALM_ON[14] = 0 
        setCheck("IRM2 Tip/Tilt      ",tscv.Tip_Tilt_Drive_On, 1, "ON", "OFF",10)
        shortCheck("Tip_Tilt Theta X ", tscs.Tip_Tilt_X_Real_Angle.val(), 0.0, 0.25, "", 11, False)
        shortCheck("Tip_Tilt Theta Y ", tscs.Tip_Tilt_Y_Real_Angle.val(), 0.0, 0.25, "", 12, False)
        shortCheck("Tip_Tilt Z(SM)Pos", tscs.Tip_Tilt_Z_SM_Real_Position.val(), 0.0, 0.05, "mm", 13, False)
        shortCheck("Tip_Tilt Z(RC)Pos", tscs.Tip_Tilt_Z_RC_Real_Position.val(), 0.0, 0.05, "mm", 14, False) 

    # Rotator Drive "ON" and "SYNCH" checking
    if tscv.OBE_Name[:20] == "S-Cam" or tscv.OBE_Name[:20] == "FMOS" :
    #if tscv.P_Rotator_Drive_Ready == 1 :
    #if tscv.Rotator_POpt_Selected == 1 :
        setCheck("POpt Rotator Drive ",tscv.P_Rotator_Drive_On, 1, "ON", "OFF", 15)
        setCheck("POpt Rot. SYNC_Mode",tscv.P_Rotator_SYNC_Mode,1, "SYNC", "ASYNC", 16)
    else :
        setCheck("Cs/Ns Rotator Drive",tscv.Rotator_Drive_On, 1, "ON", "OFF", 15)
        # Modified to work w/ASYNC,SYNC & SYNC(Zenith) since no tscv var for SYNC(Zenith)
        if tscv.InRImR_ASYNC_Mode == 0 :
            if tscv.InRImR_SYNC_Mode == 0 :
                setCheck("Cs/Ns Rot.SYNC_Mode",tscv.InRImR_SYNC_Mode, 0, "ZENTH", "ASYNC", 16)
            else :
                setCheck("Cs/Ns Rot.SYNC_Mode",tscv.InRImR_SYNC_Mode, 1, "SYNC", "ASYNC", 16)
        else :
            setCheck("Cs/Ns Rot.SYNC_Mode",tscv.InRImR_ASYNC_Mode, 0, "SYNC", "ASYNC", 16)


    # P & Cs/NsOpt ADC EL synched checking   
    name = tscv.OBE_Name[:20]
    if name =="S-Cam" :
        # setCheck("P_ADC Drive        ", tscv.P_ADC_Drive_On, 1, "ON", "OFF", 17)
        setCheck("P_ADC_SYNC_Mode    ", tscv.P_ADC_SYNC_Mode, 1, "SYNC", "ASYNC", 17)
    elif name == "FOCAS" or name == "HDS" :
        setCheck("Cs/NsOpt ADC SYNC  ", tscv.ADC_EL_SYNC_Mode, 1, "SYNC", "ASYNC",17)
    else :
        setCheck("Cs/NsOpt ADC SYNC  ", tscv.ADC_EL_ASYNC_Mode, 1, "ASYNC", "SYNC",17)      
        ALM_ON[17] = 0
        
        
    # Dome Flat Lamps On and Shutter Open Checking
    domeClosed, shutterStrg = isDomeClosed()
    if domeClosed == 0 :
        if domeFlatLampOn() == 1 :
            if ALM_ON[18] == 1 :
                print "\x1b[1;41m13: Dome Flat Lamps      ON\x1b[0m"
                print "\x1b[1;41m    Open:%s\x1b[0m%s" %(shutterStrg, BELL)
            else:
                print "18: Dome Flat Lamps    "+" \x1b[1;34m ON\x1b[0m"
        else:
            if ALM_ON[18] == 1 :
                print "18: Dome Flat Lamps    "+" \x1b[1;32m OFF\x1b[0m"
            else:
                print "18: Dome Flat Lamps    "+" \x1b[1;34m OFF\x1b[0m"
    else : # All shutters and ventilators are closed.
        if domeFlatLampOn() == 1 :       
            if ALM_ON[18] == 1 :
                print "18: Dome Flat Lamps    "+" \x1b[1;32m ON\x1b[0m"
            else:
                print "18: Dome Flat Lamps    "+" \x1b[1;34m ON\x1b[0m"
        else:
            if ALM_ON[18] == 1 :
                print "18: Dome Flat Lamps    "+" \x1b[1;32m OFF\x1b[0m"
            else:
                print "18: Dome Flat Lamps    "+" \x1b[1;34m OFF\x1b[0m"
    
    longCheck("AG CCDTemp -41/-39", tscl.AG_CCD_Temperature.val(), -40, 1.1, "C", 19)
    setCheck("Wind Screen Drive  ",tscv.Wind_Screen_Drive_On, 1, "ON", "OFF", 20)
    # Check if Chiller D has taken over for Chiller A
    if tscv.Rdn_Exh_A_Selected == 0 :
        longCheck("A:Tel Coolant       -9/3", tscl.Heat_Exh_TLSCP_Coolant_Temp.val(), -3., 6., "C",21)
        longCheck("A:Tel Ret Coolant -6/6.2", tscl.Heat_Exh_TLSCP_Coolant_Return_Temp.val(), 0.1, 6.1, "C",22)
        longCheck("A:Tel Cool. Flow   17/25", tscl.Heat_Exh_TLSCP_Coolant_Flow.val(), 4, 21.0, " ",23)
        longCheck("A:Mir Coolant     -15/11", tscl.Heat_Exh_Mirror_Coolant_Temp.val(), -2.0, 13.0, "C",24)
        longCheck("A:Mir Ret Coolant  -7/12", tscl.Heat_Exh_Mirror_Coolant_Return_Temp.val(), 2.5, 9.5, "C",25)
        longCheck("A:Mir Cool.  Flow  2.8/6", tscl.Heat_Exh_Mirror_Coolant_Flow.val(), 4.4, 1.6, " ",26)
    else : 
        longCheck("D:Tel Coolant    ", tscl.Rdn_Exh_A_TLSCPB_Coolant_Temp.val(), -1.5, 6.5, "C",21)
        longCheck("D:Tel Ret Coolant", tscl.Rdn_Exh_A_TLSCPB_Return_Temp.val(), 0.5, 5.5, "C",22)
        longCheck("D:Tel Cool. Flow ", tscl.Rdn_Exh_A_TLSCPB_Flow.val(), 5.5, 4.0, " ",23)
        longCheck("D:Mir Coolant    ", tscl.Rdn_Exh_A_MirrorC_Coolant_Temp.val(), -2.0, 13.0, "C",24)
        longCheck("D:Mir Ret Coolant", tscl.Rdn_Exh_A_MirrorC_Return_Temp.val(), 2.5, 9.5, "C",25)
        longCheck("D:Mir Cool.  Flow", tscl.Rdn_Exh_A_MirrorC_Flow.val(), 4.0, 2.0, " ",26)
    # Check if Chiller D has taken over for Chiller B       
    if tscv.Rdn_Exh_B_Selected == 0 :
        longCheck("B:Cryo Coolant  2.5/10.5", tscl.Cryogenics_Exh_Coolant_Temp.val(), 6.5, 4, "C",27)
        longCheck("B:Cryo Ret Cool.    8/28", tscl.Cryogenics_Exh_Coolant_Return_Temp.val(), 18, 10, "C", 28)
        longCheck("B:Cryo Cool.Flow 3.9/5.1", tscl.Cryogenics_Exh_Coolant_Flow.val(), 4.5, 0.6, " ",29)
    else :    
        longCheck("D:Cryo Coolant   ", tscl.Rdn_Exh_A_TLSCPB_Coolant_Temp.val(),12.5, 4.8, "C",27)
        longCheck("D:Cryo Ret Cool. ", tscl.Rdn_Exh_A_TLSCPB_Return_Temp.val(),20.54, 5.25, "C",28)
        longCheck("D:Cryo Cool. Flow", tscl.Rdn_Exh_A_TLSCPB_Flow.val(), 4.5, 2.0, " ",29)

########### Checking AG!
    if tscv.AG1_Auto_Guide == 1:  
        if tscl.AG_Star_Position1_Error_X.val()==0 and tscl.AG_Star_Position1_Error_Y.val():
            setCheck("Auto Guide         ",tscv.AG1_Auto_Guide, 0, "OFF", "ON", 30)
            print"  Xerror  ", tscl.AG_Star_Position1_Error_X.val(),"Yerror  ", tscl.AG_Star_Position1_Error_Y.val()
        if tscl.AG_Star_Position1_Error_X.val()>800  or tscl.AG_Star_Position1_Error_Y.val()>800:
            setCheck("Auto Guide         ",tscv.AG1_Auto_Guide, 0, "OFF", "ON", 30)
            print"  Xerror  ", tscl.AG_Star_Position1_Error_X.val(),"Yerror  ", tscl.AG_Star_Position1_Error_Y.val()
#       if tscl.AG_Star_Position1_Intensity.val() < tscv.AG_Lower_Limit1.val():
#           setCheck("Auto Guide         ",tscv.AG1_Auto_Guide, 0, "OFF", "ON", 30)
#           print"Auto Guide X error  ", tscl.AG_Star_Position1_Error_X.val(),"Auto Guide Y error  ", tscl.AG_Star_Position1_Error_Y.val()
        else :
            setCheck("Auto Guide         ",tscv.AG1_Auto_Guide, 1, "ON", "OFF", 30)   
    else :
        setCheck("Auto Guide         ",tscv.AG1_Auto_Guide, 0, "OFF", "ON", 30)

    # LTCS checking
    oldtimestamp = isLTCSOK(oldtimestamp, 31, 32, 33)
    
    # OBE must be set in "Observation Condition Window" on TWS1 or TWS2       
    if tscv.OBE_Name[:20] == "S-Cam":
        setCheck("P AG/SH X Drive RDY",tscv.P_AGSH_X_Drive_Ready, 1, "YES", " NO",36)
        if isTelSlewing :
            longCheck("P AG/SH X Pos.Error",tscl.P_AGSH_X_Position_Error.val(), 0.0, 120, "mm",37)
        else :
            longCheck("P AG/SH X Pos.Error",tscl.P_AGSH_X_Position_Error.val(), 0.0, 0.065, "mm",37)
           
    print "KEY: "+"\x1b[1;42m  OK  "+"\x1b[0m"+"  "+"\x1b[1;41m BAD "+"\x1b[0m"+"  "+"\x1b[1;44mALMOFF"+"\x1b[0m"
    print 
    time.sleep(6.5)



 
