#!/usr/local/bin/python
# AG status window: Oct 2004 by Tomono
# vim: ts=4 sw=4 et ai
import shm
import tel
import time

ms = shm.memory(shm.getshmid(0x100));
tscs=tel.TSCShort();
ms.attach(); 

ml = shm.memory(shm.getshmid(0x101));
tscl=tel.TSCLong();
ml.attach();

mv = shm.memory(shm.getshmid(0x102));
tscv=tel.TSCVstat();
mv.attach();

print "#time(HST)"+\
    " Az(deg) El(deg) InR/Im-Rotator(deg) R(mm?) theta(deg?)"+\
    " DetXcenter1(pix) DetYcenter1(pix) DetXwidth1(pix) DetYwidth1(pix)"+\
    " DetXcenter2(pix) DetYcenter2(pix) DetXwidth2(pix) DetYwidth2(pix)"+\
    " LowerLim1(ADU) UpperLim1(ADU) LowerLim2(ADU) UpperLim2(ADU)"+\
    " TargetX1(pix) TargetY1(pix) TargetX2(pix) TargetY2(pix)"+\
    " CurrentX1(pix) CurrentY1(pix) CurrentX2(pix) CurrentY2(pix)"+\
    " ErrorX1(mas) ErrorY1(mas) ErrorX2(mas) ErrorY2(mas)"+\
    " Update-date(HST) Update-time(HST)"

while 1:
    tscs.set(ms.read(1292))
    tscl.set(ml.read(9044))
    tscv.vset(mv.read(12931))

    tm = time.localtime( time.time() )
    print time.strftime("%Y/%m/%d-%H:%M:%S", tm) +\
        " %11.6f" %( tscs.AZ_Real_Angle.val()) +\
        " %11.6f" %( tscs.EL_Real_Angle.val()) +\
        " %9.4f" %( tscs.Rotator_Real_Angle.val()) +\
        " %9.4f" %( tscv.AGUTO_Guide_r_Real_Position.val()) +\
        " %9.4f" %( tscv.Auto_Guide_AG_Position_Real_Angle.val()) +\
        " %3ld %3ld %3ld %3ld" %(
                tscv.AG_Star_Position1_DET_Area_X.val(),
                tscv.AG_Star_Position1_DET_Area_Y.val(),
                tscv.AG_Star_Position1_DET_Area_Width_X.val(),
                tscv.AG_Star_Position1_DET_Area_Width_Y.val()
        ) +\
        " %3ld %3ld %3ld %3ld" %(
                tscv.AG_Star_Position2_DET_Area_X.val(),
                tscv.AG_Star_Position2_DET_Area_Y.val(),
                tscv.AG_Star_Position2_DET_Area_Width_X.val(),
                tscv.AG_Star_Position2_DET_Area_Width_Y.val()
        ) +\
        " %7ld %7ld" %(
                tscv.AG_Lower_Limit1.val(),
                tscv.AG_Upper_Limit1.val()
        ) +\
        " %7ld %7ld" %(
                tscv.AG_Lower_Limit2.val(),
                tscv.AG_Upper_Limit2.val()
        ) +\
        " %3ld %3ld" %(
                tscv.AG_Star_Position1_X.val(),
                tscv.AG_Star_Position1_Y.val()
        ) +\
        " %3ld %3ld" %(
                tscv.AG_Star_Position2_X.val(),
                tscv.AG_Star_Position2_Y.val()
        ) +\
        " %3ld %3ld" %(
                tscl.AG_Star1_Gravity_Position_X.val(),
                tscl.AG_Star1_Gravity_Position_Y.val()
        ) +\
        " %3ld %3ld" %(
                tscl.AG_Star2_Gravity_Position_X.val(),
                tscl.AG_Star2_Gravity_Position_Y.val()
        ) +\
        " %8.4f %8.4f" %(
                tscl.AG_Star_Position1_Error_X.val(),
                tscl.AG_Star_Position1_Error_Y.val()
        ) +\
        " %8.4f %8.4f" %(
                tscl.AG_Star_Position2_Error_X.val(),
                tscl.AG_Star_Position2_Error_Y.val()
        ) +\
        " %04.0lf/%02.0lf/%02.0lf %02.0lf:%02.0lf:%04.1lf" %(
                tscl.AG_Data_Time.HSTyear(),
                tscl.AG_Data_Time.HSTmonth(),
                tscl.AG_Data_Time.HSTday(),
                tscl.AG_Data_Time.HSThh(),
                tscl.AG_Data_Time.mm(),
                tscl.AG_Data_Time.ss()
        )

    time.sleep(5)
