# AG status window: Oct 2004 by Tomono
# vim: ts=4 sw=4 et ai
import curses
#------initial----
page=1
mode=0
#----------
def cus_ag(screen,tscs,ms,tscl,ml,tscv,mv):
    tscs.set(ms.read(1292))
    tscl.set(ml.read(9044))
    tscv.vset(mv.read(12931))
    maxpage=1  #--- Do not forget to modify
    global page
    if page>maxpage : page=maxpage
    if page<1 : page=1

    if page==1 :
        # table format
        ch=1
        c1=25
        c2=50
        row=2

        # focus
        if tscv.AGSH_PIR_Selected:
            focus="primary IR"
        elif tscv.AGSH_POpt_Selected:
            focus="primary Optical"
        elif tscv.AGSH_Cs_Selected:
            focus="Cassegrain"
        elif tscv.AGSH_NsIR_Selected:
            focus="Nasmyth IR"
        elif tscv.AGSH_NsOpt_Selected:
            focus="Nasmyth Optical"
        screen.addstr( row, 0, "Auto Guider", curses.A_REVERSE)
        screen.addstr( row, 13, focus, curses.A_NORMAL)

        # telescope status
        row+=2
        screen.addstr( row, c1, "Real values", curses.A_NORMAL)
        row+=1
        screen.addstr( row, ch, "Az (deg)", curses.A_NORMAL)
        screen.addstr( row, c1, "%11.6f" %(
            tscs.AZ_Real_Angle.val()
        ), curses.A_NORMAL)
        row+=1
        screen.addstr( row, ch, "El (deg)", curses.A_NORMAL)
        screen.addstr( row, c1, "%11.6f" %(
            tscs.EL_Real_Angle.val()
        ), curses.A_NORMAL)
        row+=1
        screen.addstr( row, ch, "InR/Im Rotator (deg)", curses.A_NORMAL)
        screen.addstr( row, c1, "%9.4f" %(
            tscs.Rotator_Real_Angle.val()
        ), curses.A_NORMAL)

        # mechanical status
        row+=1
        screen.addstr( row, ch, "R (mm)", curses.A_NORMAL)
        screen.addstr( row, c1, "%9.4f" %(
            tscv.AGUTO_Guide_r_Real_Position.val()
        ), curses.A_NORMAL)
        row+=1
        screen.addstr( row, ch, "theta (deg)", curses.A_NORMAL)
        screen.addstr( row, c1, "%9.4f" %(
            tscv.Auto_Guide_AG_Position_Real_Angle.val()
        ), curses.A_NORMAL)

        # column titles
        row+=2
        screen.addstr( row, c1, "Star1", curses.A_NORMAL)
        screen.addstr( row, c2, "Star2", curses.A_NORMAL)

        # guide stars
        row+=1
        screen.addstr( row, ch, "Detection area (pix)", curses.A_NORMAL)
        for star in [
            [ c1,
                tscv.AG_Star_Position1_DET_Area_X.val(),
                tscv.AG_Star_Position1_DET_Area_Y.val(),
                tscv.AG_Star_Position1_DET_Area_Width_X.val(),
                tscv.AG_Star_Position1_DET_Area_Width_Y.val() ],
            [ c2,
                tscv.AG_Star_Position2_DET_Area_X.val(),
                tscv.AG_Star_Position2_DET_Area_Y.val(),
                tscv.AG_Star_Position2_DET_Area_Width_X.val(),
                tscv.AG_Star_Position2_DET_Area_Width_Y.val() ]
        ] :
            screen.addstr( row, star[0], "%3ld,%-3ld - %3ld,%-3ld" %(
                star[1] - star[3]/2,
                star[2] - star[4]/2,
                star[1] + star[3]/2,
                star[2] + star[4]/2
            ), curses.A_NORMAL)

        row+=1
        screen.addstr( row, ch, "Threshold (ADU)", curses.A_NORMAL)
        for star in [
            [ c1,
                tscv.AG_Lower_Limit1.val(),
                tscv.AG_Upper_Limit1.val() ],
            [ c2,
                tscv.AG_Lower_Limit2.val(),
                tscv.AG_Upper_Limit2.val() ],
        ] :
            screen.addstr( row, star[0], "%7ld - %-7ld" %(
                star[1], star[2]
            ), curses.A_NORMAL)

        row+=1
        screen.addstr( row, ch, "Target (pix)", curses.A_NORMAL)
        for star in [
            [ c1,
                tscv.AG_Star_Position1_X.val(),
                tscv.AG_Star_Position1_Y.val() ],
            [ c2,
                tscv.AG_Star_Position2_X.val(),
                tscv.AG_Star_Position2_Y.val() ],
        ] :
            screen.addstr( row, star[0], "%3ld,%-3ld" %(
                star[1], star[2]
            ), curses.A_NORMAL)

        row+=2
        screen.addstr( row, ch, "Measured (pix)", curses.A_NORMAL)
        for star in [
            [ c1,
                tscl.AG_Star1_Gravity_Position_X.val(),
                tscl.AG_Star1_Gravity_Position_Y.val() ],
            [ c2,
                tscl.AG_Star2_Gravity_Position_X.val(),
                tscl.AG_Star2_Gravity_Position_Y.val() ],
        ] :
            screen.addstr( row, star[0], "%3ld,%-3ld" %(
                star[1], star[2]
            ), curses.A_NORMAL)

        row+=1
        screen.addstr( row, ch, "Error (mas)", curses.A_NORMAL)
        for star in [
            [ c1,
                tscl.AG_Star_Position1_Error_X.val() * 100,
                tscl.AG_Star_Position1_Error_Y.val() * 100 ],
            [ c2,
                tscl.AG_Star_Position2_Error_X.val() * 100,
                tscl.AG_Star_Position2_Error_Y.val() * 100 ],
        ] :
            screen.addstr( row, star[0], "%8.4f,%-8.4f" %(
                star[1] * 0.01, star[2] * 0.01
            ), curses.A_NORMAL)

        row+=2
        screen.addstr( row, ch, "Updated (HST)", curses.A_NORMAL)
        screen.addstr( row, c1,
            "%04.0lf/%02.0lf/%02.0lf %02.0lf:%02.0lf:%04.1lf" %(
                tscl.AG_Data_Time.HSTyear(),
                tscl.AG_Data_Time.HSTmonth(),
                tscl.AG_Data_Time.HSTday(),
                tscl.AG_Data_Time.HSThh(),
                tscl.AG_Data_Time.mm(),
                tscl.AG_Data_Time.ss()),
        curses.A_NORMAL)

        screen.hline(1, 59, curses.ACS_HLINE, 7)
        screen.addstr(1, 59, "(%ld/%ld)" %(page,maxpage), curses.A_NORMAL)
        screen.addstr(0, 77, "", curses.A_STANDOUT)
        screen.refresh()
