#!/usr/local/bin/python

import sys
import tel
import shm
import time
import commands
import string
import urllib
import dewpt


############################### C O N S T A N T S ###############################
ERR="ERROR - "
WRNG="WARNING -"
BELL="\a\a\a\a\a\a\a"
ALM_ON=[1,1,1,1,1, 1,1,1,1,1, 1,1,1,1,1, 1,1,1,1,1, 1,1,1,1,1, 1,1,1,1,1, 1,1,1,1,1, 1,1,1,1,1]
DEBUG = False
# LTCS Constants -- CHANGE HERE
SLEW_PCT = 0.035945
SCAM_AZ_SLEWRATE = 0.5564 * SLEW_PCT
SCAM_EL_SLEWRATE = 0.5564 * SLEW_PCT
MAX_ALLOW_ERROR = 8.00
DEGTOARCSEC = 3600.0
LTCSURL = 'http://ltcs.naoj.hawaii.edu:8011/ltcs.html/'
LTCSSTRG = "TIMESTAMP1"
RADiffLim = 0.002
DECDiffLim = 0.002
ZENITH = 89.85
YESINDEX = 313



locTime=""
oldtimestamp = -10000000


def printUsage() :
    print
    print
    print "USAGE: ./SysChkr.py"
    print "or     ./SysChkr.py -[h|H]"
    print "or     ./SysChkr.py -[s|S] [DISABLE_STRING]"
    print
    print "OPTIONS"
    print "     -h or -H   prints this help and exits."
    print "     -s or -S   silence alarm(s) for items specified in the DISABLE_STRING."
    print
    print "DISABLE_STRING"
    print "     string of numbers corresponding to the number to the left of the alarm"
    print "     that is to be silenced.  More than one alarm can be silence by separating the"
    print "     numbers by commas."
    print
    print "     e.g. ./SysChkr.py -s  0,3,10"
    print
    print "     would result in item zero (EL Drive), third item (Dome Drive), seventh item"
    print "     (IRM2 Tip/Tilt) to have their respective alarms silenced."
    print

# Checking to see that this is the first instance of this Python script running.
#print commands.getoutput('ps -e | grep SysChkr | wc -l | cut -c 7-9' )
#numInst = commands.getoutput('ps -e | grep SysChkr | wc -l | cut -c 7-9')
#if numInst[0] != '1' :
#    print "SysChkr.py: Another SysChkr1py Python script is currently running."
#    print "SysChkr.py: Only one SysChkr.py is allowed to run at any given time."
#    print "SysChkr.py: Kill the currently running SysChkr.py script before starting again."
#    sys.exit(0)
def setAlmOff(idx) :
    
    global ALM_ON
    
    if idx > -1 and idx < len(ALM_ON) :
        ALM_ON[idx] = 0


     
# A function to parse -s/S (silence alarm) into tokens and then validate the
# tokens into valid index entries into the ALM_ON alarm list.
# Input:  inStr - input string containing indices into DISABLE_MODE string.
# Returns: 1 (check was successful)/
def parseSilStr(inStr) :

    strLen = len(inStr)
    aIStr = ""
    almIdx = -1

#    print inStr+" len = %d" %strLen
    idx = 0
    while idx < strLen :
        if inStr[idx].isdigit() == True :
#            print "inStr[%d] = %s is a digit" %(idx, inStr[idx])
            aIStr = aIStr + inStr[idx]
#            print "aIStr = " + aIStr
            almIdx = int(aIStr)
#            print "almIdx = %d" %almIdx
        elif inStr[idx] == "," :
#            print "inStr[%d] = %s is a comma" %(idx, inStr[idx])
            if len(aIStr) > 0 :
                almIdx = int(aIStr)
            aIStr = ""
#            print "almIdx = %d" %almIdx
            setAlmOff(almIdx)
            almIdx = -1
        else :
            print ERR+"invalid alphabetic character in alarm silence field."
            sys.exit(0)
        idx = idx + 1

    # Set the ALM_ON list for the last index which is not delimited by a comma.
    setAlmOff(almIdx)
    


# Checking for command line parameters.
if len(sys.argv) > 1 :
    if sys.argv[1] == "-h" or sys.argv[1] == "-H" :
        printUsage()
        sys.exit(0)
    elif sys.argv[1] == "-s" or sys.argv[1] == "-S" :
         if len(sys.argv) > 2 :
             DISABLE_STRING = sys.argv[2]
#             print "DISABLE_STRING = " + DISABLE_STRING
             parseSilStr(DISABLE_STRING)
         else :
             print ERR+"Missing silence alarm field"
             sys.exit(0)
    else :
        print "SysChkr.py : Invalid option %s selected." %sys.argv[1]
        printUsage()
        sys.exit(0)


# Setting up shared memory for type short
ms = shm.memory(shm.getshmid(0x100));
tscs=tel.TSCShort();
ms.attach(); 


# Setting up shared memory for type long
ml = shm.memory(shm.getshmid(0x101));
tscl=tel.TSCLong();
ml.attach();


# Setting up shared memory for type vstat
mv = shm.memory(shm.getshmid(0x102));
tscv=tel.TSCVstat();
mv.attach(); 


# Initial read of shared memory from TSC
tscs.set(ms.read(1292))
tscl.set(ml.read(1292*7))
tscv.vset(mv.read(12931))


# Check if Vstat connection between TSC-TWS4 is working.
print "Checking Vstat TSC-TWS4 connection."
prev_ss = tscv.time0000.ss()
t_cnt = 0
ss = prev_ss
# 600 iterations * 0.2 sec = 120 second timeout period.
while (ss == prev_ss and t_cnt < 600) :
    tscv.vset(mv.read(12391))
    prev_ss = ss
    ss = tscv.time0000.ss()
    t_cnt = t_cnt + 1
    if (ss == prev_ss) :
        time.sleep(0.2)
if (ss == prev_ss) :
    print ERR+"Vstat timestamp is not updating.  ABORTING!" 
    print "At the command prompt, type the following: /home/naoj/bin/after_reboot_tsc"
    print "Then re-run this script."
    sys.exit()  # Aborting program.


# ANSI Color Codes for terminals.
#print '\x1b[1;32m%s\x1b[0m'% ('I am bold green')
#print '\x1b[1;31m%s\x1b[0m'% ('I am bold red')
#print '\x1b[4;31m%s\x1b[0m'% ('I am underlined red')
print '\x1b[1;33m%s\x1b[0m'% ('I am bold yellow')
#print '\x1b[1;4;31m%s\x1b[0m'% ('I am bold underlined red')
#print '\x1b[7;31m%s\x1b[0m'% ('I am reverse red')
print '\x1b[6;31m%s\x1b[0m'% ('I am fast blinking reverse red')
#print '\x1b[1;41m%s\x1b[0m'% ('I am bold white on red background')
#print '\x1b[5;1;41m%s\x1b[0m'% ('I am blinking bold white on red bkgd.')



# TSC Variable Checking Function
# Input:  prefText - prefix text string to print out.
#         tsclName - Name of tscv variable i.e. tscl.Weather_Humidity.val()
#         value - desired value
#         error - acceptable error (+/- error)
#         sufText - suffix text string to print out.
# Returns: 1 (check was successful)
def scheck(prefText, tscsName, value, error, sufText, idx) :

    lowValue = value - error
    hiValue = value + error
    tscValue = tscsName

    strVal = "%10.2f" %tscValue
    strVal = string.rjust(strVal, 5)
    idxStr = "%d: " %idx
    idxStr = string.rjust(idxStr, 4)
    
    if tscValue > lowValue and tscValue < hiValue :
        print idxStr+prefText+"\x1b[1;32m  %s%s\x1b[0m" %(strVal, sufText)
    else:
#        print "\x1b[1;41m"+idxStr+prefText+"  %s%s%s\x1b[0m" %(strVal, sufText, BELL )
         print "\x1b[5;1;41m" + idxStr+prefText+"  %s%s%s\x1b[0m" %(strVal, sufText, BELL )
    return 1



# Item checking function for TSC variables.
#         Determines if item should be checked or not depending upon
#         char [d|D] in DISABLE_MODE string
# Input:  prefText - prefix text string to report.
#         tscsName - Name of tscs variable i.e. tscs.Tip_Tilt_X_Real_Angle.val()
#         value - desired value
#         error - acceptable error (+/- error)
#         sufText - suffix text string to print out.
#         idx - index into DISABLE_MODE string
# Returns: 1 (check was successful)/
def shortCheck(prefText, tscsName, value, error, SufText, idx, cautionFlg) :

    strVal = "%10.2f" %tscsName
    strVal = string.rjust(strVal, 5)
    idxStr = "%d: " %idx
    idxStr = string.rjust(idxStr, 4)
    
    if ALM_ON[idx] == 0 :
        print idxStr+prefText+"\x1b[1;34m  %s%s\x1b[0m" %(strVal,SufText)
    elif cautionFlg :
        print idxStr+prefText+"\x1b[1;33m  %s%s\x1b[0m" %(strVal,SufText)
    else : 
        scheck(prefText, tscsName, value, error, SufText, idx);
    return 1    # end of shortCheck #



# Function to check if telescope is slewing in AZ or EL.
# Input:  none
# Returns: 1 telescope is slewing. 0 otherwise
def isTelSlewing() :

    slewFlg = True
    azSlewFlg = True
    elSlewFlg = True
    
    if tscl.AZ_Rate_REF.val() > -SCAM_AZ_SLEWRATE and tscl.AZ_Rate_REF.val() < SCAM_AZ_SLEWRATE :
        if DEBUG :
            print "AZ NOT SLEWING at ", tscl.AZ_Rate_REF.val()
        azSlewFlg = False


    if tscl.EL_Rate_REF.val() > -SCAM_EL_SLEWRATE and tscl.EL_Rate_REF.val() < SCAM_EL_SLEWRATE :
        if DEBUG :
            print "EL NOT SLEWING at ", tscl.EL_Rate_REF.val()
        elSlewFlg = False

    if not azSlewFlg and not elSlewFlg :
        slewFlg = False

    if not tscv.Mount_Auto_Guiding_Mode and not tscv.Mount_Pointing_Mode and not tscv.Mount_Open_Tracking_Mode :
        slewFlg = True

    return slewFlg   # end of isTelSlewing #
  


print
print "Ringing the bell.  Adjust volume so that bell is audible" +  BELL
print "Control-C to quit this program."
print "** Results not valid if TSC is rebooted after this script has started!"
print
time.sleep(2)


while True :
    # Get latest data from tscv shared memory.
    tscv.vset(mv.read(12931))

    # Get latest data from tscs shared memory
    tscs.set(ms.read(1292))
    
    # Get latest data from tscl shared memory
    tscl.set(ml.read(1292*7))
    

    # When adding items to be monitored don't forget to add the index as the last entry in setCheck or
    # longCheck.  Also, add a "1" to the ALM_ON list for each item added.

    # Telescope AZ/EL Position Error checking.
    if isTelSlewing() :
        telSlewFlg1 = True
    else :
        telSlewFlg1 = False

    # Delay reading to allow LASER_IMPACT flag to change when slowing down from a slew.
    time.sleep(0.5)

    # Telescope AZ/EL Position Error checking.
    if isTelSlewing() :
        telSlewFlg2 = True
    else :
        telSlewFlg2 = False

    # Get and format the timestamp for this computer not TSC timestamp.
    locTime = time.strftime("%d%b%Y %H:%M:%S ", time.localtime())
    print locTime
    ###date = time.strftime("%d%b%Y:  ", time.localtime())
    ###TSC_Time = "%02.0lf:%02.0lf:%04.1lf" %(tscv.time0000.HSThh(),tscv.time0000.mm(),tscv.time0000.ss())
    ###print date + TSC_Time
    ###print "Mount_Slew_Mode = ", tscv.Mount_Slew_Mode
    ###print "Dome_Slew_Mode = ", tscv.Dome_Slew_Mode   
    ###print "Mount_CMD_VEL_ANS = %12.4f" %(tscl.Mount_CMD_VEL_ANS.val() * DEGTOARCSEC)
    print "Telescope Pointing", tscv.Telescope_Pointing
    print "Telescope Tracking", tscv.Telescope_Tracking
    
    if (not telSlewFlg1) & (not telSlewFlg2) :
        shortCheck("AZ Position Error", tscs.AZ_Position_Error.val() * 3600.0, 0.0, 8.0, "as",1, False)
        shortCheck("AZ Rate REF Slew ", tscl.AZ_Rate_REF.val() * 3600.0, 0.0, SCAM_AZ_SLEWRATE * 3600.0, "as/sec",2, False)
        shortCheck("EL Position Error", tscs.EL_Position_Error.val() * 3600.0, 0.0, 8.0, "as",3, False)
        shortCheck("EL Rate REF Slew ", tscl.EL_Rate_REF.val() * 3600.0, 0.0, SCAM_AZ_SLEWRATE * 3600.0, "as/sec",4, False)
    else :
        shortCheck("AZ Position Error", tscs.AZ_Position_Error.val() * 3600.0, 0.0, 8.0, "as",1, True)
        shortCheck("AZ Rate REF Slew ", tscl.AZ_Rate_REF.val() * 3600.0, 0.0, SCAM_AZ_SLEWRATE * 3600.0, "as/sec",2, True)
        shortCheck("EL Position Error", tscs.EL_Position_Error.val() * 3600.0, 0.0, 8.0, "as",3, True)
        shortCheck("EL Rate REF Slew ", tscl.EL_Rate_REF.val() * 3600.0, 0.0, SCAM_AZ_SLEWRATE * 3600.0, "as/sec",4, True)

    ###print "AZ Rate REF Slew %12.5f" %(tscl.AZ_Rate_REF.val() * 3600.00)
    ###print "EL Rate REF Slew %12.5f" %(tscl.EL_Rate_REF.val() * 3600.00)
    print "TSC Time %02.0lf:%02.0lf:%04.1lf" %(tscv.time0000.HSThh(),tscv.time0000.mm(),tscv.time0000.ss())
    print
    time.sleep(0.5)



 
