#!/usr/local/bin/python

import sys
import tel
import shm
import time
import commands

# String variables and constants
locTime=""
FILE_NAME="/home/naoj/bin.stview/SCStatus.log"
ERR="ERROR - "
WRNG="WARNING -"
BELL="\a\a\a\a\a\a\a"
global IRFullOpen
global IRFullClose
global OptFullOpen
global OptFullClose
global stateChg


def printUsage() :
    print
    print
    print "USAGE: ./SCLogger.py"
    print "or     ./SCLogger.py -[h|H]"
    print "or     ./SCLogger.py -[f|F] [FILE_NAME]"
    print "or     ./SCLogger.py -[n|N]"
    print
    print "OPTIONS"
    print "     -h or -H   prints this help and exits."
    print "     -f or -F   write status information to file named FILE_NAME"
    print "                default logging file: SCStatus.log"
    print "     -n or -N   no logging to file (write to terminal)"
    print
    print



# Set toScreen flag to false, i.e. print out results to default logging file,
toTerminal = False



# Checking for command line parameters.
if len(sys.argv) > 1 :
    if sys.argv[1] == "-h" or sys.argv[1] == "-H" :
        printUsage()
        sys.exit(0)
    elif sys.argv[1] == "-f" or sys.argv[1] == "-F" :
#        print "-d or -D option selected."
        if len(sys.argv) > 2 :
            FILE_NAME = sys.argv[2]
        else :
            print "DSLogger.py : ERROR -- No logging file name specified."
            printUsage()
            sys.exit(0)
    elif sys.argv[1] == "-n" or sys.argv[1] == "-N" :
        toTerminal = True
    else :
        print "DSLogger.py : Invalid option %s selected." %sys.argv[1]
        printUsage()
        sys.exit(0)


# Setting up shared memory for type short
#ms = shm.memory(shm.getshmid(0x100));
#tscs=tel.TSCShort();
#ms.attach(); 


# Setting up shared memory for type long
ml = shm.memory(shm.getshmid(0x101));
tscl=tel.TSCLong();
ml.attach();


# Setting up shared memory for type vstat
mv = shm.memory(shm.getshmid(0x102));
tscv=tel.TSCVstat();
mv.attach(); 


## Initial read of shared memory from TSC
# A function to determined if a variable being monitored has changed its
#tscs.set(state.
#tscl.set(ml.read(1292*7))
tscv.vset(mv.read(12931))


# ANSI Color Codes for terminals.
#print '\x1b[1;32m%s\x1b[0m'% ('I am bold green')
#print '\x1b[1;31m%s\x1b[0m'% ('I am bold red')
#print '\x1b[4;31m%s\x1b[0m'% ('I am underlined red')
#print '\x1b[1;4;31m%s\x1b[0m'% ('I am bold underlined red')
#print '\x1b[1;41m%s\x1b[0m'% ('I am bold white on red background')
#print '\x1b[5;1;41m%s\x1b[0m'% ('I am blinking bold white on red bkgd.')

FILE = open(FILE_NAME,"a")

# Function to send output either to terminal or file 
# Returns: 1 (check was successful)/
def fileW(outStrg, FILEHAND) :

    if toTerminal == True :
        print outStrg
        okay = 1
    else :
        okay = FILEHAND.write(outStrg+"\n")        
    return okay



# Write out to the log file that the program is now starting
locTime = time.strftime("%d%b%Y %H:%M:%S HST", time.localtime())
outStrg = locTime + "  --------------------    SCLogger is now starting.    --------------------"
fileW(outStrg, FILE)

# Use raw_input as input is unsafe as it evaluates your python code as commands and can cause someone
# to hack your code. 
outStrg = "TSC:    " + raw_input("Enter Sec+Config as reported by TSC:  ")
fileW(outStrg, FILE)
outStrg = "EnvLog: " + raw_input("Enter Sec+Config as reported to Environment log:  ")
fileW(outStrg, FILE)
# Write out to the log file the Secondary Unit that is installed.
if tscv.Top_Unit_Code_SMCU.a[0] == '\x01' :
    outStrg = "TopUnit = CsOpt"
    fileW(outStrg, FILE)
elif tscv.Top_Unit_Code_SMCU.a[0] == 'x02' :
    outStrg = "TopUnit = NsOpt"
    fileW(outStrg, FILE)
elif tscv.Top_Unit_Code_SMCU.a[0] == 'x03' :
    outStrg = "TopUnit = IR"
    fileW(outStrg, FILE)
elif tscv.Top_Unit_Code_SMCU.a[0] == 'x04' :
    outStrg = "TopUnit = P"
    fileW(outStrg, FILE)

# Write out to the log file the Rotator Selected tscv variables.
outStrg = "Cs Rotator Selected = %s" %tscv.Rotator_Cs_Selected
fileW(outStrg, FILE)
outStrg = "NsOpt Rotator Selected = %s" %tscv.Rotator_NsOpt_Selected
fileW(outStrg, FILE)
outStrg = "NsIR Rotator Selected = %s" %tscv.Rotator_NsIR_Selected
fileW(outStrg, FILE)
outStrg = "P Rotator Selected = %s" %tscv.P_Rotator_Selected
fileW(outStrg, FILE)
outStrg = "PIR Rotator Selected = %s" %tscv.Rotator_PIR_Selected
fileW(outStrg, FILE)
outStrg = "POpt Rotator Selected = %s" %tscv.Rotator_POpt_Selected
fileW(outStrg, FILE)
outStrg = "Rotator Drive On = %s" %tscv.Rotator_Drive_On
fileW(outStrg, FILE)
outStrg = "Rotator Drive Ready = %s" %tscv.Rotator_Drive_RDY
fileW(outStrg, FILE)
outStrg = "Rotator Drive Off = %s" %tscv.Rotator_Drive_Off
fileW(outStrg, FILE)

# Write out to the log file the P & Cs/Ns Rotator Synch'ed mode
outStrg = "P Rotator Sync Mode = %s" %tscv.P_Rotator_SYNC_Mode
fileW(outStrg, FILE)
outStrg = "Cs/Ns Rotator Async Mode = %s" %tscv.InRImR_ASYNC_Mode
fileW(outStrg, FILE)
outStrg = "Cs/Ns Rotator Sync Mode = %s" %tscv.InRImR_SYNC_Mode
fileW(outStrg, FILE)

# Write out to the log file the ADC status variables.
outStrg = "ADC EL SYNC Mode = %s" %tscv.ADC_EL_SYNC_Mode
fileW(outStrg, FILE)
outStrg = "ADC_Drive_On = %s" %tscv.ADC_Drive_On
fileW(outStrg, FILE)

# Write out to the log file 3rd Mirror status variables
outStrg = "_3rd_Mirror_IR_In_ANS = %s" %tscv._3rd_Mirror_IR_In_ANS
fileW(outStrg, FILE)
outStrg = "_3rd_Mirror_Opt_In_Ans = %s" %tscv._3rd_Mirror_Opt_In_ANS
fileW(outStrg, FILE)

# Write out to the log file the various tscv variables that monitor IR/ImR status
outStrg = "ImR_Blue_In =  %s" %tscv.ImR_Blue_In
fileW(outStrg, FILE)
outStrg = "ImR_Blue_Out = %s" %tscv.ImR_Blue_Out
fileW(outStrg, FILE)
outStrg = "ImR_Blue_Selected = %s" %tscv.ImR_Blue_Selected
fileW(outStrg, FILE)
outStrg = "ImR_None_Selected = %s" %tscv.ImR_None_Selected
fileW(outStrg, FILE)
outStrg = "ImR_Not_Used = %s" %tscv.ImR_Not_Used
fileW(outStrg, FILE)
outStrg = "ImR_Red_In = %s" %tscv.ImR_Red_In
fileW(outStrg, FILE)
outStrg = "ImR_Red_Out = %s" %tscv.ImR_Red_Out
fileW(outStrg, FILE)
outStrg = "ImR_Red_Selected = %s" %tscv.ImR_Red_Selected
fileW(outStrg, FILE)
outStrg = "ImR_SW_CONT_NsOpt_Selected = %s" %tscv.ImR_SW_CONT_NsOpt_Selected
fileW(outStrg, FILE)
outStrg = "ImR_SW_CONT_NsIR_Selected = %s" %tscv.ImR_SW_CONT_NsIR_Selected
fileW(outStrg, FILE)
outStrg = "ImR_Switching_Stop = %s" %tscv.ImR_Switching_Stop
fileW(outStrg, FILE)
outStrg = "ImR_Used = %s" %tscv.ImR_Used
fileW(outStrg, FILE)
outStrg = "InRImR_ASYNC_Mode = %s" %tscv.InRImR_ASYNC_Mode
fileW(outStrg, FILE)
outStrg = "InRImR_SYNC_Mode = %s" %tscv.InRImR_SYNC_Mode
fileW(outStrg, FILE)
outStrg = "MA_IECPT_NsIR_ImR = %s" %tscv.MA_IECPT_NsIR_ImR
fileW(outStrg, FILE)
outStrg = "MA_IECPT_NsIR_PLUS_Cs_PLUS_ImR = %s" %tscv.MA_IECPT_NsIR_PLUS_Cs_PLUS_ImR
fileW(outStrg, FILE)
outStrg = "MA_IECPT_NsIR_PLUS_OPT_PLUS_ImR = %s" %tscv.MA_IECPT_NsIR_PLUS_OPT_PLUS_ImR
fileW(outStrg, FILE)
outStrg = "MA_IECPT_NsOptCs_PLUS_ImR_Blue = %s" %tscv.MA_IECPT_NsOptCs_PLUS_ImR_Blue
fileW(outStrg, FILE)
outStrg = "MA_IECPT_NsOptIR_PLUS_ImR_Blue = %s" %tscv.MA_IECPT_NsOptIR_PLUS_ImR_Blue
fileW(outStrg, FILE)
outStrg = "MA_IECPT_NsOpt_ADC_ImR_Blue = %s" %tscv.MA_IECPT_NsOpt_ADC_ImR_Blue
fileW(outStrg, FILE)
outStrg = "MA_IECPT_NsOpt_ADC_ImR_RED = %s" %tscv.MA_IECPT_NsOpt_ADC_ImR_RED
fileW(outStrg, FILE)
outStrg = "MA_IECPT_NsOpt_ImR_Blue = %s" %tscv.MA_IECPT_NsOpt_ImR_Blue
fileW(outStrg, FILE)
outStrg = "MA_IECPT_NsOpt_ImR_Red = %s" %tscv.MA_IECPT_NsOpt_ImR_Red
fileW(outStrg, FILE)
outStrg = "MA_IECPT_NsOpt_PLUS_Cs_PLUS_ADC_ImR_Blue = %s" %tscv.MA_IECPT_NsOpt_PLUS_Cs_PLUS_ADC_ImR_Blue
fileW(outStrg, FILE)
outStrg = "MA_IECPT_NsOpt_PLUS_Cs_PLUS_ADC_ImR_Red = %s" %tscv.MA_IECPT_NsOpt_PLUS_Cs_PLUS_ADC_ImR_Red
fileW(outStrg, FILE)
outStrg = "MA_IECPT_NsOpt_PLUS_Cs_PLUS_ImR_Red = %s" %tscv.MA_IECPT_NsOpt_PLUS_Cs_PLUS_ImR_Red
fileW(outStrg, FILE)
outStrg = "MA_IECPT_NsOpt_PLUS_IR_PLUS_ADC_ImR_Blue = %s" %tscv.MA_IECPT_NsOpt_PLUS_IR_PLUS_ADC_ImR_Blue
fileW(outStrg, FILE)
outStrg = "MA_IECPT_NsOpt_PLUS_IR_PLUS_ADC_ImR_Red = %s" %tscv.MA_IECPT_NsOpt_PLUS_IR_PLUS_ADC_ImR_Red
fileW(outStrg, FILE)
outStrg = "MA_IECPT_NsOpt_PLUS_IR_PLUS_ImR_Red = %s" %tscv.MA_IECPT_NsOpt_PLUS_IR_PLUS_ImR_Red
fileW(outStrg, FILE)
outStrg = "PA_IECPT_NsIR_Cs_PLUS_ImR = %s" %tscv.PA_IECPT_NsIR_Cs_PLUS_ImR
fileW(outStrg, FILE)
outStrg = "PA_IECPT_NsIR_Cs_PLUS_ImR_Update = %s" %tscv.PA_IECPT_NsIR_Cs_PLUS_ImR_Update
fileW(outStrg, FILE)
outStrg = "PA_IECPT_NsIR_ImR = %s" %tscv.PA_IECPT_NsIR_ImR
fileW(outStrg, FILE)
outStrg = "PA_IECPT_NsIR_ImR_Update = %s" %tscv.PA_IECPT_NsIR_ImR_Update
fileW(outStrg, FILE)
outStrg = "PA_IECPT_NsIR_OPT_PLUS_ImR = %s" %tscv.PA_IECPT_NsIR_OPT_PLUS_ImR
fileW(outStrg, FILE)
outStrg = "PA_IECPT_NsIR_OPT_PLUS_ImR_Update = %s" %tscv.PA_IECPT_NsIR_OPT_PLUS_ImR_Update
fileW(outStrg, FILE)
outStrg = "PA_IECPT_NsOpt_ADC_Cs_PLUS_ImR_B_Update = %s" %tscv.PA_IECPT_NsOpt_ADC_Cs_PLUS_ImR_B_Update
fileW(outStrg, FILE)
outStrg = "PA_IECPT_NsOpt_ADC_IR_PLUS_ImR_B_Update = %s" %tscv.PA_IECPT_NsOpt_ADC_IR_PLUS_ImR_B_Update
fileW(outStrg, FILE)
outStrg = "PA_IECPT_NsOpt_ADC_ImR_B_Update = %s" %tscv.PA_IECPT_NsOpt_ADC_ImR_B_Update
fileW(outStrg, FILE)
outStrg = "PA_IECPT_NsOpt_ADC_ImR_Blue = %s" %tscv.PA_IECPT_NsOpt_ADC_ImR_Blue
fileW(outStrg, FILE)
outStrg = "PA_IECPT_NsOpt_ADC_ImR_RED = %s" %tscv.PA_IECPT_NsOpt_ADC_ImR_RED
fileW(outStrg, FILE)
outStrg = "PA_IECPT_NsOpt_ADC_ImR_R_Update = %s" %tscv.PA_IECPT_NsOpt_ADC_ImR_R_Update
fileW(outStrg, FILE)
outStrg = "PA_IECPT_NsOpt_Cs_PLUS_ADC_ImR_Blue = %s" %tscv.PA_IECPT_NsOpt_Cs_PLUS_ADC_ImR_Blue
fileW(outStrg, FILE)
outStrg = "PA_IECPT_NsOpt_Cs_PLUS_ADC_ImR_R_Update = %s" %tscv.PA_IECPT_NsOpt_Cs_PLUS_ADC_ImR_R_Update
fileW(outStrg, FILE)
outStrg = "PA_IECPT_NsOpt_Cs_PLUS_ADC_ImR_Red = %s" %tscv.PA_IECPT_NsOpt_Cs_PLUS_ADC_ImR_Red
fileW(outStrg, FILE)
outStrg = "PA_IECPT_NsOpt_Cs_PLUS_ImR_B_Update = %s" %tscv.PA_IECPT_NsOpt_Cs_PLUS_ImR_B_Update
fileW(outStrg, FILE)
outStrg = "PA_IECPT_NsOpt_Cs_PLUS_ImR_Blue = %s" %tscv.PA_IECPT_NsOpt_Cs_PLUS_ImR_Blue
fileW(outStrg, FILE)
outStrg = "PA_IECPT_NsOpt_Cs_PLUS_ImR_R_Update = %s" %tscv.PA_IECPT_NsOpt_Cs_PLUS_ImR_R_Update
fileW(outStrg, FILE)
outStrg = "PA_IECPT_NsOpt_Cs_PLUS_ImR_Red = %s" %tscv.PA_IECPT_NsOpt_Cs_PLUS_ImR_Red
fileW(outStrg, FILE)
outStrg = "PA_IECPT_NsOpt_IR_PLUS_ADC_ImR_Blue = %s" %tscv.PA_IECPT_NsOpt_IR_PLUS_ADC_ImR_Blue
fileW(outStrg, FILE)
outStrg = "PA_IECPT_NsOpt_IR_PLUS_ADC_ImR_R_Update = %s" %tscv.PA_IECPT_NsOpt_IR_PLUS_ADC_ImR_R_Update
fileW(outStrg, FILE)
outStrg = "PA_IECPT_NsOpt_IR_PLUS_ADC_ImR_Red = %s" %tscv.PA_IECPT_NsOpt_IR_PLUS_ADC_ImR_Red
fileW(outStrg, FILE)
outStrg = "PA_IECPT_NsOpt_IR_PLUS_ImR_B_Update = %s" %tscv.PA_IECPT_NsOpt_IR_PLUS_ImR_B_Update
fileW(outStrg, FILE)
outStrg = "PA_IECPT_NsOpt_IR_PLUS_ImR_Blue = %s" %tscv.PA_IECPT_NsOpt_IR_PLUS_ImR_Blue
fileW(outStrg, FILE)
outStrg = "PA_IECPT_NsOpt_IR_PLUS_ImR_R_Update = %s" %tscv.PA_IECPT_NsOpt_IR_PLUS_ImR_R_Update
fileW(outStrg, FILE)
outStrg = "PA_IECPT_NsOpt_IR_PLUS_ImR_Red = %s" %tscv.PA_IECPT_NsOpt_IR_PLUS_ImR_Red
fileW(outStrg, FILE)
outStrg = "PA_IECPT_NsOpt_ImR_B_Update = %s" %tscv.PA_IECPT_NsOpt_ImR_B_Update
fileW(outStrg, FILE)
outStrg = "PA_IECPT_NsOpt_ImR_Blue = %s" %tscv.PA_IECPT_NsOpt_ImR_Blue
fileW(outStrg, FILE)
outStrg = "PA_IECPT_NsOpt_ImR_R_Update = %s" %tscv.PA_IECPT_NsOpt_ImR_R_Update
fileW(outStrg, FILE)
outStrg = "PA_IECPT_NsOpt_ImR_Red = %s" %tscv.PA_IECPT_NsOpt_ImR_Red
fileW(outStrg, FILE)

# Append two blank lines to the end of the file to make things pretty.
outStrg = "\n"
fileW(outStrg, FILE)

#Close the file.
FILE.close()


 
