#!/usr/local/bin/python

import sys
import tel
import shm
import time
import commands
import string

# String variables and constants
locTime=""
ERR="ERROR - "
WRNG="WARNING -"
FILE_NAME="/home/naoj/bin.stview/FocusAG.log"
writeFile = False

def printUsage() :
    print
    print
    print "USAGE: ./GetFocusAG.py"
    print "or     ./GetFocusAG.py -[h|H]"
    print "or     ./GetFocusAG.py -[f|F] [FILE_NAME]"
    print
    print "OPTIONS"
    print "     -h or -H   prints this help and exits."
    print "     -f or -F   write status information to file named FILE_NAME"
    print "                default logging file: FocusAG.log"   
    print
    print

# Checking for command line parameters.
if len(sys.argv) > 1 :
    if sys.argv[1] == "-h" or sys.argv[1] == "-H" :
        printUsage()
        sys.exit(0)
    elif sys.argv[1] == "-f" or sys.argv[1] == "-F" :
        writeFile = 1
        if len(sys.argv) > 2 :
            FILE_NAME = sys.argv[2]
    else :
        print "GetFocusAG.py : Invalid option %s selected." %sys.argv[1]
        printUsage()
        sys.exit(0)


# Setting up shared memory for type short
ms = shm.memory(shm.getshmid(0x100));
tscs=tel.TSCShort();
ms.attach(); 


# Setting up shared memory for type long
ml = shm.memory(shm.getshmid(0x101));
tscl=tel.TSCLong();
ml.attach();


# Setting up shared memory for type vstat
mv = shm.memory(shm.getshmid(0x102));
tscv=tel.TSCVstat();
mv.attach(); 


# Initial read of shared memory from TSC
tscs.set(ms.read(1292))
tscl.set(ml.read(1292*7))
tscv.vset(mv.read(12931))


# Check if Vstat connection between TSC-TWS4 is working.
#print "Checking Vstat TSC-TWS4 connection."
prev_ss = tscv.time0000.ss()
t_cnt = 0
ss = prev_ss
# 600 iterations * 0.2 sec = 120 second timeout period.
while (ss == prev_ss and t_cnt < 600) :
    tscv.vset(mv.read(12391))
    prev_ss = ss
    ss = tscv.time0000.ss()
    t_cnt = t_cnt + 1
    if (ss == prev_ss) :
        time.sleep(0.2)
if (ss == prev_ss) :
    #print ERR+"Vstat timestamp is not updating.  ABORTING!" 
    #print "At the command prompt, type the following: /home/naoj/bin/after_reboot_tsc"
    #print "Then re-run this script." 
    StrVal = "00/00/0000,00:00,-999.99,-99.99,N/A,-9.99,-9.99,-9.99,-99.99,N/A,N/A,N/A,-9.99,-9.99,-9.99,-9.99,-9.99,-9.99,-9.99,"
    StrVal = StrVal + "-9.99,-9.99,-9.99,-9.99,-9.99,-9.99,-9.99,-9.99,-9.99,N/A,-9.99,-9.99,-9.99,-9.99,-9.99,N/A,-9.99,"
    StrVal = StrVal + "N/A,-9.99,Cloud Cover,-9.99,-9.99"
    print StrVal
    sys.exit()  # Aborting program.


def roundOff(value, rndVal) :

    if value < 0.0 :
        rndVal = value - rndVal
    else :
        rndVal = value + rndVal
 
    return rndVal


# Get and format the date for this computer not TSC date in HST.
locDate = time.strftime("%m/%d/%Y", time.localtime())
strVal = locDate
# Get and format the timestamp for this computer not TSC timestamp in HST
locTime = time.strftime("%H:%M", time.localtime())
strVal = strVal + "," + locTime
# Concatenate AZ Real to output string
strVal = strVal + ",%5.2f" %(roundOff(tscs.AZ_Real_Angle.val(),0.5))
# Concatenate EL Real to output string
strVal = strVal + ",%5.2f" %(roundOff(tscs.EL_Real_Angle.val(),0.5))
# Concatenate AG Only field
strVal = strVal + ",AG"
# Concatenate dummy VGW
strVal = strVal + ",-9.999"
# Concatenate dummy VGW error
strVal = strVal + ",-9.99"
# Concatenate dummy Best Z
strVal = strVal + ",-9.9999"
# Concatenate Auto Focus Z value 
strVal = strVal + ",%5.4f" %tscv.SM_Auto_Focus_Z_Offset_Position.val()
# Concatenate Auto Focus On/Off
if tscv.SM_Auto_Focus_Adjustment_On :
    strVal = strVal + ",ON" 
else :
    strVal = strVal + ",OFF"

# Determine which Top Unit is being is used. 
if tscv.Top_Unit_Code_SMCU.a[0] == '\x01' :   # Cs Opt Secondary
    TopUnit = "CsOpt"
    if tscv.Rotator_Cs_Selected == 1 :
	Focus = "Cs"
    elif tscv.Rotator_NsOpt_Selected == 1 :
	Focus = "NsOpt"
    elif tscv.Rotator_NsIR_Selected == 1 :
	Focus = "NsIR"
    elif tscv.Rotator_PIR_Selected == 1 :
	Focus = "Invalid Value: PIR"
    elif tscv.Rotator_POpt_Selected == 1 :
	Focus = "Invalid Value: POpt"
elif tscv.Top_Unit_Code_SMCU.a[0] == '\x02' : # Ns Opt Secondary
    TopUnit = "NsOpt"
    if tscv.Rotator_NsIR_Selected == 1 :
        Focus = "NsIR"
    elif tscv.Rotator_NsOpt_Selected == 1 :
        Focus = "NsOpt"
elif tscv.Top_Unit_Code_SMCU.a[0] == '\x03' : # IR Secondary
    TopUnit = "IR"
    if tscv.Rotator_Cs_Selected == 1 :
        Focus = "Cs"
    elif tscv.Rotator_NsIR_Selected == 1 :
        Focus = "NsIR"
    elif tscv.Rotator_NsOpt_Selected == 1 :
        Focus = "NsOpt"
    elif tscv.Rotator_PIR_Selected == 1:
        Focus = "Invalid Value: PIR"
    elif tscv.Rotator_POpt_Selected == 1:
        Focus = "Invalid Value: POpt"
elif tscv.Top_Unit_Code_SMCU.a[0] == '\x04' : # Primary Secondary
    TopUnit = "P"
    Focus = "P"
#    if tscv.Rotator_POpt_Selected == 1 :
    TopUnit = TopUnit + "Opt"
#    else :
#        TopUnit = TopUnit + "IR"
elif tscv.Top_Unit_Code_SMCU.a[0] == '\x05' : # PIR Secondary
    TopUnit = "PIR"
    Focus = "PIR"
else :
    TopUnit = "Invalid Top Unit"

# Determine if ADC is being used.    
if tscv.ADC_EL_SYNC_Mode == 1 :
    TopUnit = TopUnit + "+ADC"

# Determine which ImR setting is being used.
if tscv.InRImR_ASYNC_Mode != 1 :
    #if tscv.Rotator_Drive_On == 1 :
    #    if Focus == "NsOpt" or Focus == "NsIR" :
    if Focus == "NsIR" :
        TopUnit = TopUnit + "+ImR"
    elif Focus == "NsOpt" and tscv.ImR_Blue_Selected == 1 and tscv.ImR_Blue_In == 1 :
        TopUnit = TopUnit + " Blue"
    elif Focus == "NsOpt" and tscv.ImR_Red_Selected == 1 and tscv.ImR_Red_In == 1 :
        TopUnit = TopUnit + " Red"

# Concatenate TSC Focus             
strVal = strVal + "," + Focus
# Concatenate Secondary & Configuration Info
strVal = strVal + "," + TopUnit
# Concatenate Tower Wind
strVal = strVal + ",%3.1f" %tscl.Weather_Wind_Velocity_AVG.val()
# Concatenate Roof Wind (Rear)
strVal = strVal + ",%3.1f"  %tscl.Roof_R_AVG_WVEL_Data.val()
# Find maximum Top Ring data
n1 = tscl.Top_Ring_F_WVEL_Data.val()
n2 = tscl.Top_Ring_R_WVEL_Data.val()
if n1 > n2 :
    max = n1
else :
    max = n2    
strVal = strVal + ",%3.1f" %max
# Concatenate Cell X,Y,Z windspeed for Front and Rear
strVal = strVal + ",%4.2f" %tscl.CSCT_R_WVEL_X_Data.val() # Note use R (rear) for Cell Front X,Y,Z values as Cell Front and
strVal = strVal + ",%4.2f" %tscl.CSCT_R_WVEL_Y_Data.val() # Cell Rear tscl variables are reversed. 
strVal = strVal + ",%4.2f" %tscl.CSCT_R_WVEL_Z_Data.val() # Note using R (rear) instead of F (front)
strVal = strVal + ",%4.2f" %tscl.CSCT_F_WVEL_X_Data.val() # Note use F (front) for Cell Rear X,Y,Z values as Cell Rear and
strVal = strVal + ",%4.2f" %tscl.CSCT_F_WVEL_Y_Data.val() # Cell Front tscl variables are reversed.
strVal = strVal + ",%4.2f" %tscl.CSCT_F_WVEL_Z_Data.val() # Note using F (front) instead of R (rear)
# Concatenate average Front Truss windspeeds
n1 = tscl.U_TRS_F_Temp1_Data.val()
n2 = tscl.U_TRS_F_Temp2_Data.val()
avg = (n1 + n2) / 2.0
strVal = strVal + ",%4.2f" %avg
# Concatenate average OPT Truss windspeeds
n1 = tscl.U_TRS_Opt_Temp1_Data.val()
n2 = tscl.U_TRS_Opt_Temp2_Data.val() 
avg = (n1 + n2) / 2.0
strVal = strVal + ",%4.2f" %avg
# Concatenate average Rear Truss windspeeds
n1 = tscl.U_TRS_R_Temp1_Data.val()
n2 = tscl.U_TRS_R_Temp2_Data.val() 
avg = (n1 + n2) / 2.0
strVal = strVal + ",%4.2f" %avg
# Concatenate average IR Truss windspeeds
n1 = tscl.U_TRS_IR_Temp1_Data.val()
n2 = tscl.U_TRS_IR_Temp2_Data.val() 
avg = (n1 + n2) / 2.0
strVal = strVal + ",%4.2f" %avg
# Concatenate Tower Wind Direction
strVal = strVal + ",%d" %tscl.Weather_Wind_Direction_AVG.val()
# Concatenate Tower Temp.
strVal = strVal + ",%4.1f" %tscl.Weather_Temperature.val()
# Concatenate Tower Humidity
strVal = strVal + ",%4.1f" %tscl.Weather_Humidity.val()
# Determine Wind Screen Sync mode and concatenate
if tscv.Wind_Screen_EL_SYNC_Mode == 1 :
    strVal = strVal + ",SYNC"
else :
    strVal = strVal + ",ASYNC"
# Calculate and concatenate Side Vent A
vA_real = tscl.Side_V_A1_Real_Position.val() / 4.89 * 25.0
vA_real = vA_real + (tscl.Side_V_A2_Real_Position.val() / 3.81 * 25.0)
vA_real = vA_real + (tscl.Side_V_A3_Real_Position.val() / 3.81 * 25.0)
vA_real = vA_real + ((tscl.Side_V_A4_Real_Position.val() / 3.81 * 25.0) + 0.5)
#print "Side_V_A4_Real = %d" %vA_real
strVal = strVal + ",%d" %vA_real
# Calculate and concatenate Side Vent B
vB_real = tscl.Side_V_B1_Real_Position.val() / 4.89 * 25.0
vB_real = vB_real + (tscl.Side_V_B2_Real_Position.val() / 3.805 * 25.0)
vB_real = vB_real + (tscl.Side_V_B3_Real_Position.val() / 3.805 * 25.0)
vB_real = vB_real + ((tscl.Side_V_B4_Real_Position.val() / 3.805 * 25.0) + 0.5)
#print "Side_V_B4_Real = %d" %vB_real
strVal = strVal + ",%d" %vB_real
# Calculate and concatenate Side Vent C
vC_real = tscl.Side_V_C1_Real_Position.val() / 4.89 * 25.0
vC_real = vC_real + (tscl.Side_V_C2_Real_Position.val() / 3.805 * 25.0)
vC_real = vC_real + (tscl.Side_V_C3_Real_Position.val() / 3.805 * 25.0)
vC_real = vC_real + ((tscl.Side_V_C4_Real_Position.val() / 3.805 * 25.0) + 0.5)
#print "Side_V_C4_Real = %d" %vC_real
strVal = strVal + ",%d" %vC_real
# Calculate and concatenate Side Vent D
vD_real = tscl.Side_V_D1_Real_Position.val() / 4.89 * 25.0
vD_real = vD_real + (tscl.Side_V_D2_Real_Position.val() / 3.805 * 25.0)
vD_real = vD_real + (tscl.Side_V_D3_Real_Position.val() / 3.805 * 25.0)
vD_real = vD_real + ((tscl.Side_V_D4_Real_Position.val() / 3.805 * 25.0) + 0.5)
#print "Side_V_D4_Real = %d" %vD_real
strVal = strVal + ",%d" %vD_real
# Calculate and concatenate Rear Vent 1-4
#strVal = strVal + ",%d" %((tscl.Rear_V1_Real_Position.val() / 9.07 * 100.0) + 0.5)
strVal = strVal + ",N/A"
strVal = strVal + ",N/A"
strVal = strVal + ",%d" %((tscl.Rear_V3_Real_Position.val() / 9.07 * 100.0) + 0.5)
strVal = strVal + ",N/A"

# The following code does not work.
# Concatenate Side Vents A-D
#strVal = strVal + ",%d" %((tscl.Side_V_A_Real_Position.val() / 4.0 * 100.0) + 0.5)
#strVal = strVal + ",%d" %((tscl.Side_V_B_CMD_Position.val() / 4.0 * 100.0) + 0.5)
#strVal = strVal + ",%d" %((tscl.Side_V_C_CMD_Position.val() / 4.0 * 100.0) + 0.5)
#strVal = strVal + ",%d" %((tscl.Side_V_D_CMD_Position.val() / 4.0 * 100.0) + 0.5)
# Concatenate Rear Vent 1-4 %open
#strVal = strVal + ",%d" %((tscl.Rear_V1_CMD_Position.val() / 9.0 * 100.0) + 0.5)
#strVal = strVal + ",%d" %((tscl.Rear_V2_CMD_Position.val() / 9.0 * 100.0) + 0.5)
#strVal = strVal + ",%d" %((tscl.Rear_V3_CMD_Position.val() / 9.0 * 100.0) + 0.5)
#strVal = strVal + ",%d" %((tscl.Rear_V4_CMD_Position.val() / 9.0 * 100.0) + 0.5)

# Concatenate Front Vent %open
strVal = strVal + ",%d" %((tscl.Front_V_Real_Position.val() / 9.07 * 100.0) + 0.5)
# Concatenate Cloud Cover
strVal = strVal + ",Cloud Cover"
# Concatenate Mirror Temp
strVal = strVal + ",%4.2f" %tscl.Heat_Exh_Mirror_Temp_Real.val()
# Concatenate Air Temp
strVal = strVal + ",%3.1f" %tscl.Heat_Exh_Open_Air_Temp_TLSCP.val()

if writeFile == True :
    FILE = open(FILE_NAME,"w")
    FILE.write(strVal)
    FILE.close()
else :
    print strVal
