#!/usr/local/bin/python

import sys
import tel
import shm
import time
import commands
import string

# String variables and constants
locTime=""
ERR="ERROR - "
WRNG="WARNING -"
FILE_NAME="/home/naoj/bin.stview/FocusAG.log"


def printUsage() :
    print
    print
    print "USAGE: ./GetFocusAG.py"
    print "or     ./GetFocusAG.py -[h|H]"
#    print "or     ./GetFocusAG.py -[f|F] [FILE_NAME]"
    print
    print "OPTIONS"
    print "     -h or -H   prints this help and exits."
#    print "     -f or -F   write status information to file named FILE_NAME"
#    print "                default logging file: FocusAG.log"   
    print
    print

# Checking for command line parameters.
if len(sys.argv) > 1 :
    if sys.argv[1] == "-h" or sys.argv[1] == "-H" :
        printUsage()
        sys.exit(0)
#    elif sys.argv[1] == "-f" or sys.argv[1] == "-F" :
#       print "-d or -D option selected."
#        if len(sys.argv) > 2 :
#            FILE_NAME = sys.argv[2]
    else :
        print "GetFocusAG.py : Invalid option %s selected." %sys.argv[1]
        printUsage()
        sys.exit(0)


# Setting up shared memory for type short
ms = shm.memory(shm.getshmid(0x100));
tscs=tel.TSCShort();
ms.attach(); 


# Setting up shared memory for type long
ml = shm.memory(shm.getshmid(0x101));
tscl=tel.TSCLong();
ml.attach();


# Setting up shared memory for type vstat
mv = shm.memory(shm.getshmid(0x102));
tscv=tel.TSCVstat();
mv.attach(); 


# Initial read of shared memory from TSC
tscs.set(ms.read(1292))
tscl.set(ml.read(1292*7))
tscv.vset(mv.read(12931))


# Check if Vstat connection between TSC-TWS4 is working.
#print "Checking Vstat TSC-TWS4 connection."
prev_ss = tscv.time0000.ss()
t_cnt = 0
ss = prev_ss
# 600 iterations * 0.2 sec = 120 second timeout period.
while (ss == prev_ss and t_cnt < 600) :
    tscv.vset(mv.read(12391))
    prev_ss = ss
    ss = tscv.time0000.ss()
    t_cnt = t_cnt + 1
    if (ss == prev_ss) :
        time.sleep(0.2)
if (ss == prev_ss) :
    print ERR+"Vstat timestamp is not updating.  ABORTING!" 
    print "At the command prompt, type the following: /home/naoj/bin/after_reboot_tsc"
    print "Then re-run this script."
    sys.exit()  # Aborting program.


def roundOff(value, rndVal) :

    if value < 0.0 :
        rndVal = value - rndVal
    else :
        rndVal = value + rndVal
 
    return rndVal


# Get and format the date for this computer not TSC date in HST.
locDate = time.strftime("%m/%d/%Y", time.localtime())
strVal = string.rjust(locDate,20)
print "Date(mm/dd/yy HST)"+strVal
# Get and format the timestamp for this computer not TSC timestamp in HST
locTime = time.strftime("%H:%M", time.localtime())
strVal = string.rjust(locTime,20)
print "Time(HH:MM HST)   "+strVal
#strVal = string.rjust(("%5.2f" %tscs.AZ_Real_Angle.val()),20)
strVal = string.rjust(("%5.2f" %(roundOff(tscs.AZ_Real_Angle.val(),0.5))),20)
print "AZ (Deg.)         "+strVal
strVal = string.rjust(("%5.2f" %(roundOff(tscs.EL_Real_Angle.val(),0.5))),20)
strVal = string.rjust(("%5.2f" %tscs.EL_Real_Angle.val()),20)
print "EL (Deg.)         "+strVal
##### NOTE: VGW Seeing, VGW error and Best Z has to be input by the user
strVal = "AG"
strVal = string.rjust(("%s" %strVal),20)
print "AG Only           "+strVal
strVal = string.rjust(("%5.4f" %tscv.SM_Auto_Focus_Z_Offset_Position.val()),20)
print "Auto focus z      "+strVal
if tscv.SM_Auto_Focus_Adjustment_On :
    strVal = string.rjust("ON",20)  
else :
    strVal = string.rjust("OFF",20)
print "Auto Focus Adjust."+strVal  
#print "Focus_CsIR_Selected = %s" %tscv.TSC_Focus_CsIR_Selected
#print "Focus_CsOpt_Selected = %s" %tscv.TSC_Focus_CsOpt_Selected
#print "Focus_Cs_Selected = %s" %tscv.TSC_Focus_Cs_Selected
#print "Focus_NsIR_Selected = %s" %tscv.TSC_Focus_NsIR_Selected
#print "Focus_NsOpt_Selected = %s" %tscv.TSC_Focus_NsOpt_Selected
#print "Focus_PIR_Selected = %s" %tscv.TSC_Focus_PIR_Selected
#print "Focus_POpt_Selected = %s" %tscv.TSC_Focus_POpt_Selected
#print "Top Unit P Selected = %s" %tscv.Top_Unit_P_Selected
#print "Top Unit NsOpt Selected = %s" %tscv.Top_Unit_NsOpt_Selected
#print "Top Unit CsOpt Selected = %s" %tscv.Top_Unit_CsOpt_Selected
#print "Top Unit IR Selected = %s" %tscv.Top_Unit_IR_Selected
# At present, 11/08/05, there is no way to determine TSC Focus Selection
# as all of the above commented out code does not work.
# Determine which Top Unit is being is used. 
if tscv.Top_Unit_Code_SMCU.a[0] == '\x01' :   # Cs Opt Secondary
    TopUnit = "CsOpt"
    if tscv.Rotator_Cs_Selected == 1 :
	Focus = "Cs"
    elif tscv.Rotator_NsOpt_Selected == 1 :
	Focus = "NsOpt"
    elif tscv.Rotator_NsIR_Selected == 1 :
	Focus = "Invalid Value: NsIR"
    elif tscv.Rotator_PIR_Selected == 1 :
	Focus = "Invalid Value: PIR"
    elif tscv.Rotator_POpt_Selected == 1 :
	Focus = "Invalid Value: POpt"
elif tscv.Top_Unit_Code_SMCU.a[0] == '\x02' : # Ns Opt Secondary
    TopUnit = "NsOpt"
    if tscv.Rotator_Cs_Selected == 1 :
	Focus = "Invalid Value:Cs"
    elif tscv.Rotator_NsOpt_Selected == 1 :
	Focus = "NsOpt"
    elif tscv.Rotator_NsIR_Selected == 1 :
	Focus = "Invalid Value: NsIR"
    elif tscv.Rotator_PIR_Selected == 1 :
	Focus = "Invalid Value: PIR"
    elif tscv.Rotator_POpt_Selected == 1 :
	Focus = "Invalid Value: POpt"
elif tscv.Top_Unit_Code_SMCU.a[0] == '\x03' : # IR Secondary
    TopUnit = "IR"
    if tscv.Rotator_Cs_Selected == 1 :
	Focus = "Cs"
    elif tscv.Rotator_NsOpt_Selected == 1 :
	Focus = "NsOpt"
    elif tscv.Rotator_NsIR_Selected == 1 :
	Focus = "NsIR"
    elif tscv.Rotator_PIR_Selected == 1 :
	Focus = "Invalid Value: PIR"
    elif tscv.Rotator_POpt_Selected == 1 :
	Focus = "Invalid Value: POpt"
elif tscv.Top_Unit_Code_SMCU.a[0] == '\x04' : # Primary Secondary
    TopUnit = "P"
#    if tscv.Rotator_Cs_Selected == 1 :
#	Focus = "Invalid Value:Cs"
#    elif tscv.Rotator_NsOpt_Selected == 1 :
#	Focus = "Invalid Value:NsOpt"
#    elif tscv.Rotator_NsIR_Selected == 1 :
#	Focus = "Invalid Value:NsIR"
#    elif tscv.Rotator_PIR_Selected == 1 :
#	Focus = "Invalid Value: PIR"
#    elif tscv.Rotator_POpt_Selected == 1 :
    Focus = "POpt"
#    print "Rotator_Cs_Selected = %s" %tscv.Rotator_Cs_Selected
else :
    TopUnit = "Invalid Top Unit"

# Determine if ADC is being used.    
if TopUnit != "IR" and tscv.ADC_EL_SYNC_Mode == 1 :
    TopUnit = TopUnit + "+ADC"

# Determine which ImR setting is being used.
if tscv.InRImR_ASYNC_Mode != 1 :
#if tscv.Rotator_Drive_On == 1 :
    if Focus == "NsOpt" or Focus == "NsIR" :
        TopUnit = TopUnit + "+ImR"
        if tscv.ImR_Blue_In == 1 :
            TopUnit = TopUnit + " blue"
        elif tscv.ImR_Red_In == 1 :
            TopUnit = TopUnit + " red"
strVal = string.rjust(Focus, 20)
print "Focus             "+strVal
strVal = string.rjust(TopUnit,20)
print "Secondary & Config"+strVal
strVal = string.rjust(("%4.1f" %tscl.Weather_Wind_Velocity_AVG.val()),20)
print "Tower Wind        "+strVal
strVal = string.rjust(("%4.1f"  %tscl.Roof_R_AVG_WVEL_Data.val()),20)
print "Roof Wind (Rear)  "+strVal
#strVal = string.rjust(("%5.2f" %tscl.Top_Ring_F_WVEL_Data.val()),20)
#print "Top Ring Front "+strVal
#strVal = string.rjust(("%5.2f" %tscl.Top_Ring_R_WVEL_Data.val()),20)
#print "Top Ring Rear  "+strVal 
n1 = tscl.Top_Ring_F_WVEL_Data.val()
n2 = tscl.Top_Ring_R_WVEL_Data.val()
if n1 > n2 :
    max = n1
else :
    max = n2    
strVal = string.rjust(("%4.1f" %max),20)
print "Top Ring          "+strVal
strVal = string.rjust(("%5.2f" %tscl.CSCT_R_WVEL_X_Data.val()),20) # Note use R (rear) for Cell Front X,Y,Z values as Cell Front and
print "Cell X (Front)    "+strVal
strVal = string.rjust(("%5.2f" %tscl.CSCT_R_WVEL_Y_Data.val()),20) # Cell Rear tscl variables are reversed. 
print "Cell Y (Front)    "+strVal
strVal = string.rjust(("%5.2f" %tscl.CSCT_R_WVEL_Z_Data.val()),20) # Note using R (rear) instead of F (front)
print "Cell Z (Front)    "+strVal
strVal = string.rjust(("%5.2f" %tscl.CSCT_F_WVEL_X_Data.val()),20) # Note use F (front) for Cell Rear X,Y,Z values as Cell Rear and
print "Cell X (Rear)     "+strVal
strVal = string.rjust(("%5.2f" %tscl.CSCT_F_WVEL_Y_Data.val()),20) # Cell Front tscl variables are reversed.
print "Cell Y (Rear)     "+strVal
strVal = string.rjust(("%5.2f" %tscl.CSCT_F_WVEL_Z_Data.val()),20) # Note using F (front) instead of R (rear)
print "Cell Z (Rear)     "+strVal
#print "Frnt Truss 1   %5.2f" %tscl.U_TRS_F_Temp1_Data.val()
#print "Frnt Truss 2   %5.2f" %tscl.U_TRS_F_Temp2_Data.val()
n1 = tscl.U_TRS_F_Temp1_Data.val()
n2 = tscl.U_TRS_F_Temp2_Data.val()
avg = (n1 + n2) / 2.0
strVal = string.rjust(("%5.2f" %avg),20)
print "Front Truss Temp  "+strVal
#print "Opt Truss 1    %5.2f" %tscl.U_TRS_Opt_Temp1_Data.val()
#print "Opt Truss 2    %5.2f" %tscl.U_TRS_Opt_Temp2_Data.val()
n1 = tscl.U_TRS_Opt_Temp1_Data.val()
n2 = tscl.U_TRS_Opt_Temp2_Data.val() 
avg = (n1 + n2) / 2.0
strVal = string.rjust(("%5.2f" %avg), 20)
print "OPT Truss Temp    "+strVal
#print "Rear Truss 1   %5.2f" %tscl.U_TRS_R_Temp1_Data.val()
#print "Reaf Truss 2   %5.2f" %tscl.U_TRS_R_Temp2_Data.val()
n1 = tscl.U_TRS_R_Temp1_Data.val()
n2 = tscl.U_TRS_R_Temp2_Data.val() 
avg = (n1 + n2) / 2.0
strVal = string.rjust(("%5.2f" %avg),20)
print "Rear Truss Temp   "+strVal
#print "IR Truss 1     %5.2f" %tscl.U_TRS_IR_Temp1_Data.val()
#print "IR Truss 2   = %5.2f" %tscl.U_TRS_IR_Temp2_Data.val()
n1 = tscl.U_TRS_IR_Temp1_Data.val()
n2 = tscl.U_TRS_IR_Temp2_Data.val() 
avg = (n1 + n2) / 2.0
strVal = string.rjust(("%5.2f" %avg),20)
print "IR Truss Temp     "+strVal
strVal = string.rjust(("%d" %tscl.Weather_Wind_Direction_AVG.val()),20)
print "Tower(Deg)        "+strVal
strVal = string.rjust(("%4.1f" %tscl.Weather_Temperature.val()),20)
print "Tower(degC)       "+strVal
strVal = string.rjust(("%4.1f" %tscl.Weather_Humidity.val()),20)
print "Tower_Humid (%)   "+strVal
if tscv.Wind_Screen_EL_SYNC_Mode == 1 :
    strVal = string.rjust("SYNC",20)
else :
    strVal = string.rjust("ASYNC",20)
print "Sync/Async WindScr"+strVal
strVal = string.rjust(("%d" %((tscl.Side_V_A_CMD_Position.val() / 4.0 * 100.0) + 0.5)),20)
print "SideVentA (%open) "+strVal
strVal = string.rjust(("%d" %((tscl.Side_V_B_CMD_Position.val() / 4.0 * 100.0) + 0.5)),20)
print "SideVentB (%open) "+strVal
strVal = string.rjust(("%d" %((tscl.Side_V_C_CMD_Position.val() / 4.0 * 100.0) + 0.5)),20)
print "SideVentC (%open) "+strVal
strVal = string.rjust(("%d" %((tscl.Side_V_D_CMD_Position.val() / 4.0 * 100.0) + 0.5)),20)
print "SideVentD (%open) "+strVal
strVal = string.rjust(("%d" %((tscl.Rear_V1_Real_Position.val() / 9.0 * 100.0) + 0.5)),20)
print "RearVent1 (%open) "+strVal
strVal = string.rjust(("%d" %((tscl.Rear_V2_Real_Position.val() / 9.0 * 100.0) + 0.5)),20)
print "RearVent2 (%open) "+strVal
strVal = string.rjust(("%d" %((tscl.Rear_V3_Real_Position.val() / 9.0 * 100.0) + 0.5)),20)
print "RearVent3 (%open) "+strVal
strVal = string.rjust(("%d" %((tscl.Rear_V4_Real_Position.val() / 9.0 * 100.0) + 0.5)),20)
print "RearVent4 (%open) "+strVal
strVal= string.rjust(("%d" %((tscl.Front_V_CMD_Position.val() / 9.0 * 100.0) + 0.5)),20)
print "FrontVent (%open) "+strVal
strVal = string.rjust(("%5.2f" %tscl.Heat_Exh_Mirror_Temp_Real.val()),20)
print "MIRROR TEMP.      "+strVal
strVal = string.rjust(("%4.1f" %tscl.Heat_Exh_Open_Air_Temp_TLSCP.val()),20)
print "AIR TEMP.         "+strVal
