#!/usr/local/bin/python

import sys
import tel
import shm
import time
import commands

# String variables and constants
locTime=""
FILE_NAME="/home/naoj/bin.stview/DomeShutterStatus.log"
ERR="ERROR - "
WRNG="WARNING -"
BELL="\a\a\a\a\a\a\a"
global IRFullOpen
global IRFullClose
global OptFullOpen
global OptFullClose
global stateChg


def printUsage() :
    print
    print
    print "USAGE: ./DSLogger.py"
    print "or     ./DSLogger.py -[h|H]"
    print "or     ./DSLogger.py -[f|F] [FILE_NAME]"
    print "or     ./DSLogger.py -[n|N]"
    print
    print "OPTIONS"
    print "     -h or -H   prints this help and exits."
    print "     -f or -F   write status information to file named FILE_NAME"
    print "                default logging file: DomeShutterStatus.log"
    print "     -n or -N   no logging to file (write to terminal)"
    print
    print


# Checking to see that this is the first instance of this Python script
# running.
#numInst = int(commands.getoutput('ps -ef | grep /usr/local/bin/python | grep DSLogger | wc -l | cut -c 7-9'))
#print commands.getoutput('ps -u naoj | grep DSLogger | wc -l | cut -c 7-9' )
# Write out to the log file that the program is now starting
#outStrg = commands.getoutput('ps -u naoj | grep DSLogger | wc -l | cut -c 7-9' )
numInst = int(commands.getoutput('ps -ej | grep DSLogger | wc -l | cut -c 7-9'))
#FILE = open("junkfile.txt","w")
#FILE.write(str(numInst)+"\n")
#FILE.close()
if numInst > 1 :
    print "DSLogger.py: Another DSLogger.py Python script is currently running."
    print "DSLogger.py: Only one DSLogger.py is allowed to run at any given time."
    print "DSLogger.py: Kill the currently running DSLogger.py script before starting again."
    sys.exit(0)

# Set toScreen flag to false, i.e. print out results to default logging file,
toTerminal = False

# Checking for command line parameters.
if len(sys.argv) > 1 :
    if sys.argv[1] == "-h" or sys.argv[1] == "-H" :
        printUsage()
        sys.exit(0)
    elif sys.argv[1] == "-f" or sys.argv[1] == "-F" :
#        print "-d or -D option selected."
        if len(sys.argv) > 2 :
            FILE_NAME = sys.argv[2]
        else :
            print "DSLogger.py : ERROR -- No logging file name specified."
            printUsage()
            sys.exit(0)
    elif sys.argv[1] == "-n" or sys.argv[1] == "-N" :
        toTerminal = True
    else :
        print "DSLogger.py : Invalid option %s selected." %sys.argv[1]
        printUsage()
        sys.exit(0)


# Setting up shared memory for type short
#ms = shm.memory(shm.getshmid(0x100));
#tscs=tel.TSCShort();
#ms.attach(); 


# Setting up shared memory for type long
ml = shm.memory(shm.getshmid(0x101));
tscl=tel.TSCLong();
ml.attach();


# Setting up shared memory for type vstat
mv = shm.memory(shm.getshmid(0x102));
tscv=tel.TSCVstat();
mv.attach(); 


## Initial read of shared memory from TSC
# A function to determined if a variable being monitored has changed its
#tscs.set(state.
#tscl.set(ml.read(1292*7))
tscv.vset(mv.read(12931))


# ANSI Color Codes for terminals.
#print '\x1b[1;32m%s\x1b[0m'% ('I am bold green')
#print '\x1b[1;31m%s\x1b[0m'% ('I am bold red')
#print '\x1b[4;31m%s\x1b[0m'% ('I am underlined red')
#print '\x1b[1;4;31m%s\x1b[0m'% ('I am bold underlined red')
#print '\x1b[1;41m%s\x1b[0m'% ('I am bold white on red background')
#print '\x1b[5;1;41m%s\x1b[0m'% ('I am blinking bold white on red bkgd.')


# Determines if a state has changed for a variable
# Input:  stateFlg - State flag: -1 (unknown), 0 (false), 1 (true)
#         tscvName - Name of tscv variable that needs to be monitored
# Returns: 1 if shutter state has changed else returns 0
def stateHasChg(stateFlg, tscvName) :
    global stateChg
    retVal =0
    
    if stateFlg != tscvName:
#       print "A change of state has occurred."
        stateChg = 1
        retVal = 1
        
    return retVal


 
# Determines the state of one side of the dome shutter based on
# the dome shutter FullOpen and FullClose flags.
# Input: fullOpenFlg - full open flag (boolean)
#        fullCloseFlg - full close flag (boolean)
# Returns: MOVING (Open=1/Close=1), FULL_OPEN (Open=1/Close=0),
#          FULL_CLOSED(Open=0/Close=1), INVALID (Open=1/Close=1)
def detShutState(fullOpenFlg, fullCloseFlg) :
    
    result = fullOpenFlg & fullCloseFlg

    if result == True :
        # Invalid state: both full open and close are true.
        retval = "INVALID   "
    else :
        result = fullOpenFlg | fullCloseFlg
        if result == False :
            # Shutter is probably moving or partly open/close
            retval = "MOVING    "
        elif fullOpenFlg == True :
            # Shutter is fully open.
            retval = "FULL_OPEN "
        else :
            # Shutter is fully closed.
            retval = "FULL_CLOSE"
            
    return retval
    

    
# Set initial shutter state flags
IRFullOpen = -1
IRFullClose = -1
OptFullOpen = -1
OptFullClose = -1
stateChg = 0
startFlg = 1

# Write out to the log file that the program is now starting
locTime = time.strftime("%d%b%Y %H:%M:%S HST", time.localtime())
outStrg = locTime + "  --------------------    DSLogger is now starting.    --------------------"
FILE = open(FILE_NAME,"a")
if toTerminal == True :
    print outStrg
else:
    FILE.write(outStrg+"\n")


while True :
    
    # Get latest data from tscv shared memory.
    tscv.vset(mv.read(12931))

#    stateHasChg(IRFullOpen, 1)
#    print "IRFullOpen = %d stateChg = %d" %(IRFullOpen, stateChg)
#    IRFullOpen = 1
#   print "IRFullOpen = %d stateChg = %d" %(IRFullOpen, stateChg)

    if stateHasChg(IRFullOpen, tscv.IR_Shutter_Full_Open) :
        IRFullOpen = tscv.IR_Shutter_Full_Open
#        print "IRFullOpen = %d" %IRFullOpen
    if stateHasChg(IRFullClose, tscv.IR_Shutter_Full_Close) :
        IRFullClose = tscv.IR_Shutter_Full_Close
#        print "IRFullClose = %d" %IRFullClose
    if stateHasChg(OptFullOpen, tscv.Opt_Shutter_Full_Open) :
        OptFullOpen = tscv.Opt_Shutter_Full_Open
#        print "OptFullOpen = %d" %OptFullOpen
    if stateHasChg(OptFullClose, tscv.Opt_Shutter_Full_Close) :
        OptFullClose = tscv.Opt_Shutter_Full_Close
#        print "OptFullClose = %d" %OptFullClose


    if stateChg == True :
        # Open the file for writing.
        if startFlg == 0 :
            FILE = open(FILE_NAME,"a")
        
        # Get and format the timestamp for this computer in HST
        locTime = time.strftime("%d%b%Y %H:%M:%S HST", time.localtime())

        # Determine shutter state for IR
        shutState = detShutState(IRFullOpen, IRFullClose)
        IRStrg = "IR: %s (Open = %d/Close = %d)" %(shutState,IRFullOpen,IRFullClose)
        shutState = detShutState(OptFullOpen, OptFullClose)
        OptStrg = "Opt: %s (Open = %d/Close = %d)" %(shutState,OptFullOpen,OptFullClose)
        outStrg = locTime+"  "+IRStrg+"  "+OptStrg
        if toTerminal == True :    
            print outStrg
        else :
            FILE.write(outStrg+"\n")

        #Close the file.
        FILE.close()
        startFlg = 0

    #Sleep for one minute    
    time.sleep(60)

    stateChg = False

 
