#!/usr/local/bin/python

import sys
import tel
import shm
import time

# Variables and constants
head=""
err="ERROR - "
wrng="WARNING -"
#head="SASC::"
head=""
global compChecked
global compOkay
global compBad
compChecked = 0
compOkay = 0
compBad = 0

def printUsage() :
    print
    print
    print "USAGE: ./AutoRdyForObs.py"
    print "or     ./AutoRdyForObs.py -[h|H]"
    print "or     ./AutoRdyForObs.py -[v|V]"
    print
    print "OPTIONS"
    print "     -h or -H   prints this help and exits."
    print "     -v or -V   verbose mode (print out results for each component)"
    print
    print

# Determining if verbose mode checking is desired
if len(sys.argv) > 1 :
    if sys.argv[1] == "-h" or sys.argv[1] == "-H" :
        printUsage()
        sys.exit(0)
    elif sys.argv[1] == "-v" or sys.argv[1] == "-V" :
        verbose = 1
        #print "Verbose mode selected."
    else :
        printUsage()
        sys.exit(0)
else :
    verbose = 0
    
ms = shm.memory(shm.getshmid(0x100));
tscs=tel.TSCShort();
ms.attach(); 

ml = shm.memory(shm.getshmid(0x101));
tscl=tel.TSCLong();
ml.attach();

mv = shm.memory(shm.getshmid(0x102));
tscv=tel.TSCVstat();
mv.attach(); 

tscs.set(ms.read(1292))
tscl.set(ml.read(1292*7))
tscv.vset(mv.read(12931))

print head+"Checking Vstat TSC-TWS4 connection."
# Check if Vstat connection between TSC-TWS4 is working.
prev_ss = tscv.time0000.ss()
t_cnt = 0
ss = prev_ss
# 600 iterations * 0.2 sec = 120 second timeout period.
while (ss == prev_ss and t_cnt < 600) :
    tscv.vset(mv.read(12391))
    prev_ss = ss
    ss = tscv.time0000.ss()
    t_cnt = t_cnt + 1
    if (ss == prev_ss) :
        time.sleep(0.2)

if (ss == prev_ss) :
    print head+err+"Vstat timestamp is not updating.  ABORTING!"
    print head+"At command prompt, type the following: /home/naoj/bin/after_reboot_tsc"
    print head+"See Readme.if_tsc_has_rebooted in directory /home/naoj"
    print head+"Then re-run this script."
    sys.exit()  # Aborting program.
    

#print '\x1b[1;32m%s\x1b[0m'% ('I am bold green')
#print '\x1b[1;31m%s\x1b[0m'% ('I am bold red')
#print '\x1b[4;31m%s\x1b[0m'% ('I am underlined red')
#print '\x1b[1;41m%s\x1b[0m'% ('I am bold white on red background')

# TSC V variable checking function
# Input:  prefText - prefix text string to report.
#         tscvName - Name of tscv variable i.e. tscv.Dome_Drive_Off
#         state - Correct State 1 (True) 0 (False)
#         goodSufText - good suffix text string to report.
#         badSufText - bad suffix text string to report.
# Returns: 1 (check was successful)/
def vcheck(prefText, tscvName, state, goodSufText, badSufText) :
    global compChecked
    global compOkay
    global compBad
    okay = 0
    if tscvName == state :
        if verbose :
            print head+prefText+" " + goodSufText
        okay = 1
        compOkay = compOkay + 1
    else:
        print head+err+prefText+"\x1b[1;31m %s\x1b[0m" %badSufText
        compBad = compBad + 1
    compChecked = compChecked + 1
    return okay


# TSC L variable checking function
# Input:  prefText - prefix text string to print out.
#         tsclName - Name of tscv variable i.e. tscl.Weather_Humidity.val()
#         value - desired value
#         error - acceptable error (+/- error)
#         sufText - suffix text string to print out.
# Returns: 1 (check was successful)
def lcheck(prefText, tsclName, value, error, sufText) :
    global compChecked
    global compOkay
    global compBad

    lowValue = value - error
    hiValue = value + error
    okay = 0
    if tsclName > lowValue and tsclName < hiValue :
        if verbose :
            print head+prefText+" is %s%s" % (tsclName, sufText)
            okay = 1
        compOkay = compOkay + 1
    else:
           print head+err+prefText+"\x1b[1;31m OUT OF RANGE :%s%s\x1b[0m" %(tsclName, sufText)
           compBad = compBad + 1
    compChecked = compChecked + 1
    return okay


# TSC S (Short) variable checking function
# Input:  prefText - prefix text string to print out.
#         tsclName - Name of tscv variable i.e. tscl.Weather_Humidity.val()
#         value - desired value
#         error - acceptable error (+/- error)
#         sufText - suffix text string to print out.
# Returns: 1 (check was successful)
def scheck(prefText, tscsName, value, error, sufText) :
    global compChecked
    global compOkay
    global compBad        
    lowValue = value - error
    hiValue = value + error
    okay = 0
    if tscsName > lowValue and tscsName < hiValue :
        if verbose :
            print head+prefText+" is %s%s" % (tscsName, sufText)
            okay = 1
        compOkay = compOkay + 1
    else:
        print head+err+prefText+"\x1b[1;31m OUT OF RANGE: %s%s \x1b[0m" %( tscsName, sufText)
        compBad = compBad + 1
    compChecked = compChecked + 1
    return okay

#print head+"Humidity: %.0lf %%."%tscl.Weather_Humidity.val()

# OBE can be set on "Observation Condition Window" on TWS1 or TWS2
name=tscv.OBE_Name[:20]
if name=="" :  name="invalid -- not detected"
print head+"Observation Instrument at selected focus is %s."%name

# Focal Dictionary 
foci = {'S-Cam' : 'PF',  'CIAO' : 'CS', 'IRCS' : 'CS', 'FOCAS' : 'CS' }

# Dome Checking Shutter Closed and Shutter Drive Off Checking
vcheck("Dome Main Shutter Optical is", tscv.Opt_Shutter_Full_Open, 1, "FULL_OPEN","NOT_FULL_OPEN")
vcheck("Dome Main Shutter IR is", tscv.IR_Shutter_Full_Open, 1, "FULL_OPEN", "NOT_FULL_OPEN")
#vcheck("Dome Main Shutter Drive is", tscv.CP1_Shutter_Power_Off_ANS, 1, "OFF", "ON")
##vcheck("Dome Main Shutter Drive is", tscv.Dome_Drive_Off, 1, "OFF", "ON")


#AHU On Checking
vcheck("Opt Air Conditioning is", tscv.Opt_Cooling_System_Off_ANS, 1, "OFF", "ON")
vcheck("IR Air Conditioning is", tscv.IR_Cooling_System_Off_ANS, 1, "OFF", "ON")


# Front & Rear Vent Checking
#vcheck("Front Ventilator is", tscv.Front_V_Full_Close, 1, "FULLY CLOSED", "OPEN")
#vcheck("Rear Ventilator R1 Shutter is", tscv.Rear_V_R1_Full_Close, 1, "FULLY CLOSED", "OPEN")
#vcheck("Rear Ventilator R2 Shutter is", tscv.Rear_V_R2_Full_Close, 1, "FULLY CLOSED", "OPEN")
#vcheck("Rear Ventilator R3 Shutter is", tscv.Rear_V_R3_Full_Close, 1, "FULLY CLOSED", "OPEN")
#vcheck("Rear Ventilator R4 Shutter is", tscv.Rear_V_R4_Full_Close, 1, "FULLY CLOSED", "OPEN")


# Side Vent Checking
#vcheck("Side Ventilator A1 is", tscv.Side_V_A1_Full_Close, 1, "FULLY CLOSED", "OPEN")
#vcheck("Side Ventilator A2 is", tscv.Side_V_A2_Full_Close, 1, "FULLY CLOSED", "OPEN")
#vcheck("Side Ventilator A3 is", tscv.Side_V_A3_Full_Close, 1, "FULLY CLOSED", "OPEN")
#vcheck("Side Ventilator A4 is", tscv.Side_V_A4_Full_Close, 1, "FULLY CLOSED", "OPEN")
#vcheck("Side Ventilator B1 is", tscv.Side_V_B1_Full_Close, 1, "FULLY CLOSED", "OPEN")
#vcheck("Side Ventilator B2 is", tscv.Side_V_B2_Full_Close, 1, "FULLY CLOSED", "OPEN")
#vcheck("Side Ventilator B3 is", tscv.Side_V_B3_Full_Close, 1, "FULLY CLOSED", "OPEN")
#vcheck("Side Ventilator B4 is", tscv.Side_V_B4_Full_Close, 1, "FULLY CLOSED", "OPEN")
#vcheck("Side Ventilator C1 is", tscv.Side_V_C1_Full_Close, 1, "FULLY CLOSED", "OPEN")
#vcheck("Side Ventilator C2 is", tscv.Side_V_C2_Full_Close, 1, "FULLY CLOSED", "OPEN")
#vcheck("Side Ventilator C3 is", tscv.Side_V_C3_Full_Close, 1, "FULLY CLOSED", "OPEN")
#vcheck("Side Ventilator C4 is", tscv.Side_V_C4_Full_Close, 1, "FULLY CLOSED", "OPEN")
#vcheck("Side Ventilator D1 is", tscv.Side_V_D1_Full_Close, 1, "FULLY CLOSED", "OPEN")
#vcheck("Side Ventilator D2 is", tscv.Side_V_D2_Full_Close, 1, "FULLY CLOSED", "OPEN")
#vcheck("Side Ventilator D3 is", tscv.Side_V_D3_Full_Close, 1, "FULLY CLOSED", "OPEN")
#vcheck("Side Ventilator D4 is", tscv.Side_V_D4_Full_Close, 1, "FULLY CLOSED", "OPEN")


# Vent Shutters Checking
vcheck("Vent Shutter 1 is", tscv.VentSh1_Full_Open, 1, "FULL_OPEN", "NOT_FULL_OPEN")
vcheck("Vent Shutter 2 is", tscv.VentSh2_Full_Open, 1, "FULL_OPEN", "NOT_FULL_OPEN")
vcheck("Vent Shutter 3 is", tscv.VentSh3_Full_Open, 1, "FULL_OPEN", "NOT_FULL_OPEN")
vcheck("Vent Shutter 4 is", tscv.VentSh4_Full_Open, 1, "FULL_OPEN", "NOT_FULL_OPEN")
vcheck("Vent Shutter 5 is", tscv.VentSh5_Full_Open, 1, "FULL_OPEN", "NOT_FULL_OPEN")
vcheck("Vent Shutter 6 is", tscv.VentSh6_Full_Open, 1, "FULL_OPEN", "NOT_FULL_OPEN")
vcheck("Vent Shutter 7 is", tscv.VentSh7_Full_Open, 1, "FULL_OPEN", "NOT_FULL_OPEN")
vcheck("Vent Shutter 8 is", tscv.VentSh8_Full_Open, 1, "FULL_OPEN", "NOT_FULL_OPEN")
vcheck("Vent Shutter 9 is", tscv.VentSh9_Full_Open, 1, "FULL_OPEN", "NOT_FULL_OPEN")
vcheck("Vent Shutter 10 is", tscv.VentSh10_Full_Open, 1, "FULL_OPEN", "NOT_FULL_OPEN")
vcheck("Vent Shutter 11 is", tscv.VentSh11_Full_Open, 1, "FULL_OPEN", "NOT_FULL_OPEN")
vcheck("Vent Shutter 12 is", tscv.VentSh12_Full_Open, 1, "FULL_OPEN", "NOT_FULL_OPEN")
vcheck("Vent Shutter 13 is", tscv.VentSh13_Full_Open, 1, "FULL_OPEN", "NOT_FULL_OPEN")
vcheck("Vent Shutter 14 is", tscv.VentSh14_Full_Open, 1, "FULL_OPEN", "NOT_FULL_OPEN")
vcheck("Vent Shutter 15 is", tscv.VentSh15_Full_Open, 1, "FULL_OPEN", "NOT_FULL_OPEN")
vcheck("Vent Shutter 16 is", tscv.VentSh16_Full_Open, 1, "FULL_OPEN", "NOT_FULL_OPEN")
vcheck("Vent Shutter 17 is", tscv.VentSh17_Full_Open, 1, "FULL_OPEN", "NOT_FULL_OPEN")
vcheck("Vent Shutter 18 is", tscv.VentSh18_Full_Open, 1, "FULL_OPEN", "NOT_FULL_OPEN")
vcheck("Vent Shutter 19 is", tscv.VentSh19_Full_Open, 1, "FULL_OPEN", "NOT_FULL_OPEN")
vcheck("Vent Shutter 20 is", tscv.VentSh20_Full_Open, 1, "FULL_OPEN", "NOT_FULL_OPEN")


# Top Screen Front & Rear Position and Drive Off Checking
lcheck("Top Screen Front Position is", tscl.Top_Screen_F_Real_Position.val(), 3.0, 0.08, "m")
lcheck("Top Screen Rear Position is", tscl.Top_Screen_R_Real_Position.val(), 1.5, 0.05, "m")
#vcheck("Top Screen Drive is", tscv.Top_Screen_Drive_Off, 1, "OFF", "ON")


# Wind Screen Position and Drive Off Checking
#vcheck("Wind Screen Drive is", tscv.Wind_Screen_Drive_Off, 1, "OFF", "ON")
#vcheck("Wind Screen is", tscv.Wind_Screen_Full_Down, 1, "FULL DOWN")
#vcheck("Wind Screen is", tscv.Wind_Screen_EL_ASYNC_Mode, 1, "ASYNC", "SYNC")
#lcheck("Wind Screen Real Position", tscl.Wind_Screen_Real_Position.val(), 0.0, 0.05, "m")


# Dome Drive Off and ASYNC Checking
vcheck("Dome AZ Drive is", tscv.Dome_Drive_On, 1, "ON", "OFF")
vcheck("Dome/Mount are", tscv.Dome_AZ_Remote_TSC_SYNC, 1, "SYNC", "ASYNC")
#vcheck("Dome/Mount (Remote DRDR) are", tscv.Mount_Dome_Remote_ASYNC_onDRDR, 1, "ASYNC", "SYNC")
#vcheck("Dome/Mount (Remote MTDR) are", tscv.Mount_Dome_Remote_ASYNC_onMTDR, 1, "ASYNC", "SYNC")
#vcheck("Dome/Mount (Local DRDR) are", tscv.Mount_Dome_Local_ASYNC_onDRDR, 1, "ASYNC", "SYNC")
#vcheck("Dome/Mount (Local MTDR) are", tscv.Mount_Dome_Local_ASYNC_onMTDR, 1, "ASYNC", "SYNC")
#print head+"tscv.Mount_Dome_Remote_ASYNC_onDRDR %s" %tscv.Mount_Dome_Remote_ASYNC_onDRDR
#print head+"tscv.Mount_Dome_Remote_ASYNC_onMTDR %s" %tscv.Mount_Dome_Remote_ASYNC_onMTDR
#print head+"tscv.Mount_Dome_Local_ASYNC_onDRDR %s" %tscv.Mount_Dome_Local_ASYNC_onDRDR
#print head+"tscv.Mount_Dome_Local_ASYNC_onMTDR %s" %tscv.Mount_Dome_Local_ASYNC_onMTDR


# Telescope AZ/EL Drives Off Checking
vcheck("Telescope AZ Drive is",tscv.AZ_Drive_On, 1, "ON", "OFF");
#print head+"AZ_Drive_On_Ready %s" %tscv.AZ_Drive_On_Ready
vcheck("Telescope EL Drive is",tscv.EL_Drive_On, 1, "ON", "OFF");
#print head+"EL_Drive_On_Ready %s" %tscv.EL_Drive_On_Ready


# Elevation Stow Pin Inserted Checking
vcheck("Elevation Stow Pin (Mount) is",tscv.EL_Stow_Pins_Off_From_Mount,1, "RETRACTED","INSERTED")
#vcheck("Elevation Stow Pin (Balancer) is",tscv.EL_Stow_Pins_On_From_Balancer, 1, "INSERTED")


# Cell Cover Closed Checking
#print head+"Cell_Cover_DPA_Fault %s" %tscv.Cell_Cover_DPA_Fault
#vcheck("Cell Cover is",tscv.Cell_Cover_Close, 1, "CLOSED", "OPEN")


# Primary Mirror Actuators Checking 
vcheck("Mirror Support Normal Mode is", tscv.Mirror_Support_Normal_Mode, 1, "ON", "OFF")
vcheck("A40 Correction is", tscv.A40_Correct_On, 1, "ON", "OFF")
vcheck("IEC Correction is",tscv.IEC_Correct_On, 1, "ON", "OFF")
#print head+"Actuator_CMD_IEC_Offset_Selected %s" %tscv.Actuator_CMD_IEC_Offset_Selected
#print head+"Mirror_Analysis_Correct_On %s" %tscv.Mirror_Analysis_Correct_On


# Primary Mirror Covers Closed Checking
vcheck("Mirror Cover Door U_3D_I is", tscv.PM_Cover_Door_U_3D_I_Open, 1, "OPEN", "CLOSED")
vcheck("Mirror Cover Door U_3C_I is", tscv.PM_Cover_Door_U_3C_I_Open, 1, "OPEN", "CLOSED")
vcheck("Mirror Cover Door U_3B_I is", tscv.PM_Cover_Door_U_3B_I_Open, 1, "OPEN", "CLOSED")
vcheck("Mirror Cover Door U_3A_I is", tscv.PM_Cover_Door_U_3A_I_Open, 1, "OPEN", "CLOSED")
vcheck("Mirror Cover Door U_2B_I_A is", tscv.PM_Cover_Door_U_2B_I_A_Open, 1, "OPEN", "CLOSED")
vcheck("Mirror Cover Door U_2B_I_B is", tscv.PM_Cover_Door_U_2B_I_B_Open, 1, "OPEN", "CLOSED")
vcheck("Mirror Cover Door U_2A_I_A is", tscv.PM_Cover_Door_U_2A_I_A_Open, 1, "OPEN", "CLOSED")
vcheck("Mirror Cover Door U_2A_I_B is", tscv.PM_Cover_Door_U_2A_I_B_Open, 1, "OPEN", "CLOSED")
vcheck("Mirror Cover Door U_1B_I is", tscv.PM_Cover_Door_U_1B_I_Open, 1, "OPEN", "CLOSED")
vcheck("Mirror Cover Door U_1A_I is", tscv.PM_Cover_Door_U_1A_I_Open, 1, "OPEN", "CLOSED")
vcheck("Mirror Cover_Upper U_3D is", tscv.PM_Cover_Upper_U_3D_Open, 1, "OPEN", "CLOSED")
vcheck("Mirror Cover_Upper U_3C is", tscv.PM_Cover_Upper_U_3C_Open, 1, "OPEN", "CLOSED")
vcheck("Mirror Cover_Upper U_3B is", tscv.PM_Cover_Upper_U_3B_Open, 1, "OPEN", "CLOSED")
vcheck("Mirror Cover_Upper U_3A is", tscv.PM_Cover_Upper_U_3A_Open, 1, "OPEN", "CLOSED")
vcheck("Mirror Cover_Upper U_2B is", tscv.PM_Cover_Upper_U_2B_Open, 1, "OPEN", "CLOSED")
vcheck("Mirror Cover_Upper U_2A is", tscv.PM_Cover_Upper_U_2A_Open, 1, "OPEN", "CLOSED")
vcheck("Mirror Cover_Upper U_1B is", tscv.PM_Cover_Upper_U_1B_Open, 1, "OPEN", "CLOSED")
vcheck("Mirror Cover_Upper U_1A is", tscv.PM_Cover_Upper_U_1A_Open, 1, "OPEN", "CLOSED")
vcheck("Mirror Cover_Lower L_D is", tscv.PM_Cover_Lower_L_D_Open, 1, "OPEN", "CLOSED")
vcheck("Mirror Cover_Lower L_C is", tscv.PM_Cover_Lower_L_C_Open, 1, "OPEN", "CLOSED")
vcheck("Mirror Cover_Lower L_B is", tscv.PM_Cover_Lower_L_B_Open, 1, "OPEN", "CLOSED")
vcheck("Mirror Cover_Lower L_A is", tscv.PM_Cover_Lower_L_A_Open, 1, "OPEN", "CLOSED")


# Mirror Heat Exhaust Temp Cont Checking
vcheck("Mirror Heat Exhaust Control Mode %s", tscv.Heat_Exh_Mirror_Temp_CONT_Mode, 0, "CELL_EXH", "TEMP CONT")


# Observing Support 2nd Mirror, Tip-Tilt, Dome Flat Lamps, AutoGuider, Shack-Hartmann, Rotators, ADC
vcheck("2nd Mirror SP Drive is", tscv.SP_Drive_On, 1, "ON", "OFF")
vcheck("2nd Mirror Auto Focus Adjustment is", tscv.SM_Auto_Focus_Adjustment_On, 1, "ON", "OFF")
vcheck("2nd Mirror EL Synch is", tscv._2nd_Mirror_EL_SYNC, 1, "ON", "OFF")
#lcheck("2nd Mirror X Real Position is", tscl.X_Real_Position.val(), 0.0, 0.1, " mm")
#lcheck("2nd Mirror Y Real Position is", tscl.Y_Real_Position.val(), 0.0, 0.1, " mm")
#lcheck("2nd Mirror Z Real Position is", tscl.Z_Real_Position.val(), 0.0, 0.1, " mm")
#lcheck("2nd Mirror Theta Real X is", tscl.X_Real_Angle.val(), 0.0, 0.1, " deg.")
#lcheck("2nd Mirror Theta Real Y is", tscl.Y_Real_Angle.val(), 0.0, 0.1, " deg.")


# Tip/Tilt Mirror On Checking for CsIR, NsIR, NsIR_ImR
# All of the following commented out tscv variables have not been implemented and thus DO NOT WORK
#print head+"Tip_Tilt_Tip_Tilt_Mode %s" %tscv.Tip_Tilt_Tip_Tilt_Mode
#print head+"Tip_Tilt_NsIR_Selected %s" %tscv.Tip_Tilt_NsIR_Selected
#print head+"Tip_Tilt_NsIR_ImR_Selected %s" %tscv.Tip_Tilt_NsIR_ImR_Selected
#print head+"Tip_Tilt_CsIR_Selected %s" %tscv.Tip_Tilt_CsIR_Selected
#print head+"Top_Unit_Disconnect %s" %tscv.Top_Unit_Disconnect
#print head+"Top_Unit_IR_Selected %s" %tscv.Top_Unit_IR_Selected
#print head+"Top_Unit_CsOpt_Selected %d" %tscv.Top_Unit_CsOpt_Selected
#print head+"Top_Unit_P_Selected %s" %tscv.Top_Unit_P_Selected
#print head+"Top_Unit_PIR_Selected %s" %tscv.Top_Unit_PIR_Selected
#print head+"Top_Unit_NsOpt_Selected %s" %tscv.Top_Unit_NsOpt_Selected
#print head+"TSC_Focus_CsOpt_Selected %s" %tscv.TSC_Focus_CsOpt_Selected
#if tscv.Tip_Tilt_NsIR_Selected == 1 or tscv.Tip_Tilt_NsIR_ImR_Selected == 1 or tscv.Tip_Tilt_CsIR_Selected == 1 :
if tscv.Top_Unit_Code_SMCU.a[0] == '\x03' :
    # \x01 = CsOpt  \x02 = NsOpt  \x03 = IR   \x04 = Prime Focus Top Unit
    vcheck("Tip_Tilt Drive is", tscv.Tip_Tilt_Drive_On, 1, "ON","OFF")
    vcheck("Tip_Tilt Mode is", tscv.Tip_Tilt_Position_Mode, 1, "POSITION", "CHP/TT")
    vcheck("Tip_Tilt Chopping Mode is", tscv.Tip_Tilt_Chopping_Mode, 0,"STOPPED", "STARTED")
    vcheck("Tip_Tilt Sync_Signal is",tscv.Chopping_SYNC_Signal_INT_Selected, 1, "INTERNAL","EXTERNAL")
    scheck("Tip_Tilt Theta X ", tscs.Tip_Tilt_X_Real_Angle.val(), 0.0, 0.1, "")
    scheck("Tip_Tilt Theta Y ", tscs.Tip_Tilt_Y_Real_Angle.val(), 0.0, 0.1, "")
    scheck("Tip_Tilt Z(SM)Pos", tscs.Tip_Tilt_Z_SM_Real_Position.val(), 0.0, 0.1, "mm")
    scheck("Tip_Tilt Z(RC)Pos", tscs.Tip_Tilt_Z_RC_Real_Position.val(), 0.0, 0.1, "mm")


# Dome Flat Lamps Off Checking
vcheck("All Dome Flat A Lamps are", tscv.Lamp_1_A_2_A_3_A_4_A_Light_Off, 1, "OFF", "ON")
vcheck("Dome Flat Lamp1_B is", tscv.Lamp_1_B_Light_Off, 1, "OFF", "ON")
vcheck("Dome Flat Lamp2_B is", tscv.Lamp_2_B_Light_Off, 1, "OFF", "ON")
vcheck("Dome Flat Lamp3_B is", tscv.Lamp_3_B_Light_Off, 1, "OFF", "ON")
vcheck("Dome Flat Lamp4_B is", tscv.Lamp_4_B_Light_Off, 1, "OFF", "ON")

########################################################################################################
# AG Camera/Video Checking
#vcheck("Auto Guide 1 is",tscv.AG1_Auto_Guide, 0, "OFF", "ON")
#vcheck("Auto Guide 2 is",tscv.AG2_Auto_Guide, 0, "OFF", "ON")
#vcheck("AG Exposure is", tscv.AG_Exposure_Off, 1, "OFF", "ON")
vcheck("AG Shutter is", tscv.AG_Diaphram_Full_Open, 1, "FULL_OPEN", "CLOSED")
#print "tscv.AG_Diaphram_Open %s" %tscv.AG_Diaphram_Open
if tscv.OBE_Name[:20] != "S-Cam" :
    vcheck("AG CCD Shutter is", tscv.AG_CCD_Shutter_Open, 1, "OPEN", "CLOSED")
#vcheck("AG Video Output OBS is", tscv.AG_Video_Output_OBS_Off, 1, "OFF", "ON")
#vcheck("AG Video Output TWS1 is", tscv.AG_Video_Output_TWS1_Off, 1, "OFF", "ON")
#vcheck("AG Video Output TWS2 is", tscv.AG_Video_Output_TWS2_Off, 1, "OFF", "ON")
#print head+"AG_Cs_Shutter_PS_Off %s" %tscv.AG_Cs_Shutter_PS_Off
#print head+"PIR_AG_Entrance_Shutter_Open %s" %tscv.PIR_AG_Entrance_Shutter_Open


# SV Camera/Video Checking
if tscv.OBE_Name[:20] == "HDS" :
    vcheck("SV Exposure is", tscv.SV_Exposure_On, 1, "ON", "OFF")
    vcheck("SV Shutter is", tscv.SV_Shutter_Open, 1, "OPEN", "CLOSED")
    vcheck("SV Video Output OBS is", tscv.SV_Video_Output_OBS_On, 1, "ON", "OFF")
#vcheck("SV Video Output TWS1 is", tscv.SV_Video_Output_TWS1_Off, 1, "OFF", "ON")
#vcheck("SV Video Output TWS2 is", tscv.SV_Video_Output_TWS2_Off, 1, "OFF", "ON")


# SH Camera/Video Ref. Source Checking
vcheck("SH Exposure is", tscv.SH_Exposure_Off, 1, "OFF", "ON")
if tscv.SH_POpt_Selected==1 :
    vcheck("SH POpt REF Lamp is", tscv.SH_POpt_REF_Light_Off, 1, "OFF", "ON")
elif tscv.SH_PIR_Selected==1 :
    vcheck("SH PIR REF Lamp is", tscv.SH_PIR_REF_Light_Off, 1, "OFF", "ON")
elif tscv.SH_Cs_Selected==1 :
    vcheck("SH Cs REF Lamp is", tscv.SH_Cs_REF_Light_Off, 1, "OFF", "ON")
elif tscv.SH_NsOpt_Selected==1 :
    vcheck("SH NsOpt REF Lamp is", tscv.SH_NsOpt_REF_Light_Off, 1, "OFF", "ON")
elif tscv.SH_NsIR_Selected==1 :
    vcheck("SH NsIR REF Lamp is", tscv.SH_NsIR_REF_Light_Off, 1, "OFF", "ON")
vcheck("SH CCD Shutter is", tscv.SH_CCD_Shutter_Close, 1, "CLOSED", "OPEN")
vcheck("SH REF Shutter is", tscv.SH_REF_Shutter_Close, 1, "CLOSED", "OPEN")
#vcheck("SH Video Output OBS is", tscv.SH_Video_Out_OBS_Off, 1, "OFF", "ON")
#vcheck("SH Video Output TWS1 is", tscv.SH_Video_Out_TWS1_Off, 1, "OFF", "ON")
#vcheck("SH Video Output TWS2 is", tscv.SH_Video_Out_TWS2_Off, 1, "OFF", "ON")


# Rotator Checking for POpt Focus
if name == "S-Cam" :
#if tscv.P_Rotator_Drive_Ready == 1 :
#if tscv.Rotator_POpt_Selected == 1:
#    scheck("P Rotator Angle", tscs.P_Rotator_Real_Angle.val(), 0.0, 0.1, " deg.")
    vcheck("P Rotator Drive is", tscv.P_Rotator_Drive_On, 1, "ON", "OFF")
    #print head+"Rotator_POpt_Selected %s" %tscv.Rotator_POpt_Selected
    vcheck("P_Rotator SYNC_Mode is", tscv.P_Rotator_SYNC_Mode, 1, "SYNC", "ASYNC")


# Rotator Checking for PIR Focus
elif tscv.Rotator_PIR_Selected==1 :
# elif tscv.PIR_Rotator_Drive_Ready == 1   
    print head+"Rotator_POpt_Selected %s" %tscv.Rotator_POpt_Selected
    print head+"P_Rotator_SYNC_Mode %s" %tscv.P_Rotator_SYNC_Mode


# Rotator Checking for Cs, NsOpt and NsIR Foci
else :
    #print head+"Rotator_NsIr_Selected %s" %tscv.Rotator_NsIR_Selected
    #print head+"Rotator_NsOpt_Selected %s" %tscv.Rotator_NsOpt_Selected
    #print head+"Rotator_Cs_Selected %s" %tscv.Rotator_Cs_Selected
    vcheck("Cs/Ns Instr/Img Rotator is", tscv.InRImR_SYNC_Mode, 1, "SYNC", "ASYNC")
    vcheck("Cs/Ns Rotator Drive is", tscv.Rotator_Drive_On, 1, "ON", "OFF")
#print head+"Rotator_Drive_On %s" %tscv.Rotator_Drive_On
#scheck("Rotator Angle", tscs.Rotator_Real_Angle.val(), 0.0, 0.1, " deg.")
#scheck("Cs Rotator Angle", tscs.Cs_Rotator_Real_Angle.val(), 0.0, 0.6, " deg.")
#print head+"Rotator_Position_Mount_Real_SYNC_Mode %s" %tscv.Rotator_Position_Mount_Real_SYNC_Mode


# AG/SH Probe Arm Checking for PIR Focus
#print head+"AGSH_PIR_Selected %s" %tscv.AGSH_POpt_Selected
#vcheck("Cs AGSH X Position Drive is", tscv.Cs_AGSH_X_Position_Drive_Off, 1, "OFF", "ON")         
#lcheck("POpt Probe Arm X Position is", tscl.P_AGSH_X_Real_Position.val(), 163.0, 0.025, " deg.")
#vcheck("POpt AGSH Y Position Drive is", tscv.P_AGSH_Y_Position_Drive_Off, 1, "OFF", "ON")
#lcheck("POpt Probe Arm Y Position is", tscl.P_AGSH_Y_Real_Position.val(), 0.0, 0.025, " deg.") 
#vcheck("POpt AGSH Z Position Drive is", tscv.P_AGSH_Z_Position_Drive_Off, 1, "OFF", "ON")
#lcheck("POpt Probe Arm Z Position is", tscl.P_AGSH_Z_Real_Position.val(), 0.0, 0.25, " deg.")

if name == 'S-Cam' :
#if tscv.AGSH_POpt_Selected==0 :
#if tscv.P_AGSH_X_Drive_Ready == 1 & tscv.P_AGSH_Y_Drive_Ready == 1:
    #print "STATUS: AGSH_POpt_Selected %s" %tscv.AGSH_POpt_Selected  
    print "STATUS: POpt AGSH X Position Drive is %s" %tscv.P_AGSH_X_Position_Drive_On         
    print "STATUS: POpt Probe Arm X Position is %s" %tscl.P_AGSH_X_Real_Position.val()
    print "STATUS: POpt AGSH Y Position Drive is %s" %tscv.P_AGSH_Y_Position_Drive_On
    print "STATUS: POpt Probe Arm Y Position is %s" %tscl.P_AGSH_Y_Real_Position.val()
    print "STATUS: POpt AGSH Z Position Drive is %s" %tscv.P_AGSH_Z_Position_Drive_On
    print "STATUS: POpt Probe Arm Z Position is %s" %tscl.P_AGSH_Z_Real_Position.val()


# AG/SH Probe Arm Checking for PIR Focus (Still needs work)
elif tscv.AGSH_PIR_Selected==1 :
    print head+"AGSH_PIR_Selected %s" %tscv.AGSH_PIR_Selected
    print head+"PIR_AGSH_Probe_Drive_On %s" %tscv.PIR_AGSH_Probe_Drive_On
#    print head+"AGSH_Position_Mount_SYNC_Mode: %1d " %tscv.AGSH_Position_Mount_SYNC_Mode


# AG/SH Probe Arm Checking for Cs, NsOpt, NsIR Foci
else :
    vcheck("Cs/Ns AGSH r Drive is", tscv.AGSH_r_Drive_On, 1, "ON", "Off")
    lcheck("Cs/Ns AGSH Probe Arm Position is", tscl.AGSH_r_Real_Position.val(), 140.0, 0.025, " mm")    
    vcheck("AGSH Angle Drive is", tscv.AGSH_Angle_Drive_On, 1, "ON", "OFF")
    #lcheck("Cs/Ns AGSH Theta Angle is", tscl.AGSH_Real_Angle.val(), 0.0, 0.1, "deg")
    #vcheck("AGSH Angle Probe Arm is", tscv.AGSH_Position_Mount_ASYNC_Mode, 1, "ASYNC", "SYNC")
    #print head+"AGSH_Position_Mount_ASYNC_Mode: %1d " %tscv.AGSH_Position_Mount_ASYNC_Mode
    vcheck("AGSH Angle Probe Arm is", tscv.AGSH_Angle_Telescope_ASYNC, 1, "ASYNC", "SYNC")


# Atmospheric Dispersion Corrector (ADC) Checking
if tscv.OBE_Name[:20] == "S-Cam" :
    vcheck("P_ADC Drive Motor is %s", tscv.P_ADC_Drive_On, 1, "ON", "OFF")
    vcheck("P ADC is %s", tscv.P_ADC_SYNC_Mode, 1, "SYNCH", "ASYNCH")
elif tscv.OBE_Name[:20] == "HDS" : 
    vcheck("NsOpt_ADC is %s", tscv.ADC_EL_SYNC_Mode, 1, "ON", "OFF")
    vcheck("ADC Drive Motor is %s", tscv.ADC_Drive_On, 1, "ON", "OFF")
elif tscv.OBE_Name[:20] == "FOCAS" :
    vcheck("CsOpt_ADC is %s", tscv.ADC_EL_ASYNC_Mode, 1, "OFF", "ON")
    vcheck("ADC Drive Motor is %s", tscv.ADC_Drive_Off, 1, "OFF", "ON")


# Cal_Source Shutter Closed, Cooling Fan, Halogen & Rare Gas Lamp Off Checking
vcheck("Cal Source NsIR Shutter is", tscv.Cal_Source_NsIR_Shutter_Close, 1, "CLOSED", "OPEN")
vcheck("Cal Source NsOpt Shutter is", tscv.Cal_Source_NsOpt_Shutter_Close, 1, "CLOSED", "OPEN")
vcheck("Cal Source Cs Shutter is", tscv.Cal_Source_Cs_Shutter_Close, 1, "CLOSED", "OPEN")

vcheck("Cal Source NsIR Cooling Fan is", tscv.Cal_Source_NsIR_Cooling_Fan_Off, 1, "OFF", "ON")
vcheck("Cal Source NsOpt Cooling Fan is", tscv.Cal_Source_NsOpt_Cooling_Fan_Off, 1, "OFF", "ON")
vcheck("Cal Source Cs Cooling Fan is", tscv.Cal_Source_Cs_Cooling_Fan_Off, 1, "OFF", "ON")

vcheck("Cal Source R Drive is", tscv.Cal_Source_R_Drive_Off, 1, "OFF", "ON")

vcheck("Cal Source Probe Arm is", tscv.Cal_Source_Retract_Home_Position, 1, "RETRACTED", "INSERTED")

#lcheck("Cal Source Probe Arm Position is", tscl.Cal_Source_R_Real_Position.val(), 184.2, 0.025, " mm")
#print head+"Cal Source_R_Real_Position.val() %+6.1lf" %tscl.Cal_Source_R_Real_Position.val()

vcheck("Cal Source P2_Front HC1 Lamp is", tscv.Cal_Source_P2_Front_HC1_Off, 1, "OFF", "ON")
vcheck("Cal Source P1_Rear HC1 Lamp is", tscv.Cal_Source_P1_Rear_HC1_Off, 1, "OFF", "ON")
vcheck("Cal Source NsOpt HC1 Lamp is", tscv.Cal_Source_NsOpt_HC1_Off, 1, "OFF", "ON")
vcheck("Cal Source Cs HC1 Lamp is", tscv.Cal_Source_Cs_HC1_Off, 1, "OFF", "ON")

vcheck("Cal Source NsOpt HC2 Lamp is", tscv.Cal_Source_NsOpt_HC2_Off, 1, "OFF", "ON")
vcheck("Cal Source Cs HC2 Lamp is", tscv.Cal_Source_Cs_HC2_Off, 1, "OFF", "ON")

vcheck("Cal Source NsIR Halogen1 Lamp is", tscv.Cal_Source_NsIR_Halogen1_Off, 1, "OFF", "ON")
vcheck("Cal Source NsOpt Halogen1 Lamp is", tscv.Cal_Source_NsOpt_Halogen1_Off, 1, "OFF", "ON")
vcheck("Cal Source Cs Halogen1 Lamp is", tscv.Cal_Source_Cs_Halogen1_Off, 1, "OFF", "ON")

vcheck("Cal Source NsIR Rare Gas1 Lamp is", tscv.Cal_Source_NsIR_Rare_Gas1_Off, 1, "OFF", "ON")
vcheck("Cal Source NsIR Rare Gas2 Lamp is", tscv.Cal_Source_NsIR_Rare_Gas2_Off, 1, "OFF", "ON")
vcheck("Cal Source Cs Rare Gas1 Lamp is", tscv.Cal_Source_Cs_Rare_Gas1_Off, 1, "OFF", "ON")
vcheck("Cal Source Cs Rare Gas2 Lamp is", tscv.Cal_Source_Cs_Rare_Gas2_Off, 1, "OFF", "ON")

# AO M1M6 Retracted Checking
#print head+"AO_Cal_NsIR_INTLK_SW %s" %tscv.AO_Cal_NsIR_INTLK_SW
#print head+"AO_Cal_Cs_INTLK_SW %s" %tscv.AO_Cal_Cs_INTLK_SW
#print head+"AO_Cal_NsOpt_INTLK_SW %s" %tscv.AO_Cal_NsOpt_INTLK_SW

# Totals
print head+" %d system components checked (GOOD: %d, BAD: %d)" % (compChecked, compOkay, compBad)

 
