/* optimize.h : designs a steering mirror optics */

#ifndef OPTIMIZE_H
#define OPTIMIZE_H

static char *optimze_h_rcsid __attribute__( (unused)) =
	"$Id: optimize.h,v 1.1.1.1 2004/10/27 20:14:07 tomono Exp $";

#ifdef HAVE_CONFIG_H
#include "config.h"
#endif

#include <gsl/gsl_vector.h>
#include "lens.h"

/* optimization status */
typedef enum
{
	lens_opt_success = 0,	// no error
	lens_opt_timeout,	// spent too match time in a step
	lens_opt_nomemory,	// memory allocation error
	lens_opt_unexpected,	// unexpected error in GSL
	lens_opt_toomany,	// too many iterations
	lens_opt_notdone,	// optimization not done
} optimization_status_t;

/* optimization types */
typedef enum
{
	mf_none,	// nothing
	mf_img,	// image
	mf_mag,	// magnification
	mf_amag,	// absolute magnification
} mf_operand_t;

/* an operand of merit function */
struct _merit_function_operands_s {
	char *name;	// operand name
	char *comment;	// comment (may be NULL)
	inf_double_s object;	// object distance
	int object_number;	// take distance from: -1:specified 0:star, 1:puoil
	mf_operand_t type;	// magnification, absolute mag, or image distance
	inf_double_s goal;	// goal
	int surface;	// surface
	double weight;	// weight (0: does not care)
	struct _merit_function_operands_s *next;
};
typedef struct _merit_function_operands_s merit_function_operands_s;

/* data structure for GSL/optical calculation inerface */
typedef struct
{
	lenses_s *optics;	// current optics
	inf_double_s star_obj, pupil_obj;	// object distance
	merit_function_operands_s *mf;	// merit function operands
	optimization_status_t final_status;	// final status
	double final_merit_function;	// final merit function
} optics_minimizer_s;

/* PUBLIC FUNCTIONS */
char *optimization_status_to_s( optimization_status_t status );	// returns a string showing the status
double merit_function( const optics_minimizer_s *params );	// measure of how we are close to the goal
double total_weight( const optics_minimizer_s *params );	// weight sum of merit function
double minimize( optics_minimizer_s *params, const int vf, const size_t maxiter, const unsigned int maxsteptime, const double epsabs );	// minimizes the merit function
	// 1. set the parameters in params:
	//    - optics: *optics, (star|pupil)_(obj|img|mag)
	//    - merit function: (star|pupil)_(img|mag)_weight
	// 2. call this function with:
	//    - params: containing above
	//    - vf: verbosity level
	//    - maxiter: max iterations
	//    - maxsteptime: max wait in seconds for an iteration step
	// 3. this function will return the final merit function
	//    - parames->final_status will have the final status

/* PRIVATE FUNCTIONS - written here to be tested */
/* helpers */
extern int is_alarm;	// stops the optimization routine if this is 1
void sig_handle( int signum );	// signal handler
int n_free_pars( const optics_minimizer_s *params );	// counts # of free pars
void optics_to_vector( optics_minimizer_s *params, gsl_vector *x );	// updates the vector
void vector_to_optics( optics_minimizer_s *params, const gsl_vector *x );	// updates the optics
double gsl_merit_function( const gsl_vector *x, void *params );	// GSL interface for the merit_function()
merit_function_operands_s *mf_operand_add( merit_function_operands_s *orig, const char *name, inf_double_s object, int object_number, mf_operand_t type, inf_double_s goal, int surface, double weight, char *comment );	// adds an operand. orig can be NULL
inf_double_s mf_operand_value( const merit_function_operands_s *cur, const lenses_s *optics );	// image location or (absolute) magnification
double mf_operand_delta( const merit_function_operands_s *cur, const lenses_s *optics );	// merit function for the current operand
void mf_operand_free( merit_function_operands_s *start );	// frees all the operands in the list

#endif	// OPTIMIZE_H
