/* mallocprintf.c : mallocs memory for snprintf by itself */
/* 
 * taken from the man page of printf(3) by Copyright (c) 1999 Andries
 * Brouwer (aeb at cwi.nl) and revised by jsm28 at hermes.cam.ac.uk, which
 * is distributed under the terms of GPL version 2 or later.
 */

static char *rcsid __attribute__ ((unused)) =
	"$Id: mallocprintf.c,v 1.1.1.1 2004/10/27 20:14:07 tomono Exp $";

#include <stdio.h>
#include <stdlib.h>
#include <stdarg.h>
#include "mallocprintf.h"

char *
mallocprintf( const char *fmt, ... )
{
	/* Guess we need no more than 100 bytes. */
	int n, size = 100;
	char *p;
	va_list ap;

	if( ( p = malloc (size) ) == NULL ) return NULL;
	while (1)
		{
			/* Try to print in the allocated space. */
			va_start (ap, fmt);
			n = vsnprintf (p, size, fmt, ap);
			va_end (ap);
			/* If that worked, return the string. */
			if (n > -1 && n < size) return p;
			/* Else try again with more space. */
			if (n > -1)		/* glibc 2.1 */
				size = n + 1;		/* precisely what is needed */
			else			/* glibc 2.0 */
				size *= 2;		/* twice the old size */
			if ((p = realloc (p, size)) == NULL) return NULL;
		}
}
