/* conffile_test.c : test suite for conffile.c */

static char *rcsid __attribute__((unused)) =
	"$Id: conffile_test.c,v 1.2 2004/10/27 20:50:43 tomono Exp $";

#ifdef HAVE_CONFIG_H
#include "config.h"
#endif

#include <assert.h>
#include <stdlib.h>
#include <stdio.h>
#include <string.h>

#include "conffile.h"
#include "version.h"

int main( void );

int
main( void )
{
	display_version( "conffile_test", stderr );

	/* word_get() - I had to read the output to confirm it is working well. */
	{
		size_t i;
		char *comment;
		char tstring[] = "	one two\n3.1 four 5 roku #nana hach\n";
		//char tstring[] = "	one two\n3.1 four 5 roku nana hach\n";
		words_s *w, *x;
		char *c, *n;
		c = tstring;
		while( ( w = word_get( c, &n ) ) != NULL )
			{
				fprintf( stderr, "/%s/--\"%s\"\n", w->word, n );
				word_free( w );
				c = n;
			}

		w = word_scan( tstring, &comment );
		fprintf( stderr, "%d words:", word_n( w ) );
		x = w;
		do
			{
				fprintf( stderr, " %s", word_the( x ) );
			}
		while( ( x = word_next( x ) ) != NULL );
		fprintf( stderr, "\ncomment:%s", comment );
		fputs( "\n", stderr );

		for( i = 0; i < word_n( w ); i++ )
			{
				fprintf( stderr, "%d:%s ", i + 1, word_ith( w, i ) );
			}
		fputs( "\n", stderr );

		word_free( w );
	}

	/* value_scan */
	{
		size_t i;
		char tstring[] = "one2.0three4.0e+00Five0x06nana8";
		words_s *w, *x;
		char *c, *n;
		c = tstring;
		while( ( w = value_get( c, &n ) ) != NULL )
			{
				fprintf( stderr, "/%s/--\"%s\"\n", w->word, n );
				word_free( w );
				c = n;
			}

		w = value_scan( tstring );
		fprintf( stderr, "%d values:", word_n( w ) );
		x = w;
		do
			{
				fprintf( stderr, " %s", word_the( x ) );
			}
		while( ( x = word_next( x ) ) != NULL );
		fputs( "\n", stderr );

		for( i = 0; i < word_n( w ); i++ )
			{
				fprintf( stderr, "%d:%s ", i + 1, word_ith( w, i ) );
			}
		fputs( "\n", stderr );

		word_free( w );
	}
	
	/* long line */
	{
		assert( lenses_read( "conffile_longline.txt" ) == NULL );
	}

	/* optics */
	{
		double goodmf, badmf;
		optics_minimizer_s *orig, *diff1, *diff2;

		//lenses_file_usage( stderr );

		orig = lenses_allocate( 2 );
		assert( orig );
		assert( lenses_write( orig, "conffile_test.0.lens" ) == 0 );

		to_lens( orig->optics->lenses[0], 100, 300 );
		to_lens( orig->optics->lenses[1], 201, 201 );
		orig->optics->lenses[1]->feff_is_free = 1;
		orig->optics->lenses[1]->thick_is_free = 1;
		orig->optics->lenses[1]->comment = strdup( "# This is the free lens :)" );
		orig->star_obj = to_inf_double( 100 );
		orig->pupil_obj = to_inf_inf( 1 );
		orig->mf = NULL;
		orig->mf = mf_operand_add( orig->mf, "star_img", orig->star_obj, -1, mf_img, to_inf_double( 0 ), -1, 1, NULL );
		orig->mf = mf_operand_add( orig->mf, "star_mag", orig->star_obj, -1, mf_mag, to_inf_double( -2 ), -1, 1, NULL );
		orig->mf = mf_operand_add( orig->mf, "pupil_img", orig->pupil_obj, -1, mf_img, to_inf_inf( 1 ), -1, 1, NULL );
		assert( lenses_write( orig, "conffile_test.1.lens" ) == 0 );

		badmf = merit_function( orig );
		goodmf = minimize( orig, 0, 100, 10, 1e-10 );
		fprintf( stderr, "minimization result MF:%g\n", goodmf );
		assert( goodmf <= badmf );
		assert( lenses_write( orig, "conffile_test.2.lens" ) == 0 );

		diff1 = lenses_read( "conffile_test.2.lens" );
		assert( diff1 );
		assert( lenses_write( diff1, "conffile_test.X.lens" ) == 0 );
		diff2 = lenses_read( "conffile_test.X.lens" );
		assert( diff2 );
		assert( lenses_write( diff2, "conffile_test.Y.lens" ) == 0 );
		//assert( lenses_write( diff2, "-" ) == 0 );

		lenses_free( orig );
		lenses_free( diff1 );
		lenses_free( diff2 );
	}

	/* optics with `position_from' thickness */
	{
		double goodmf, badmf;
		optics_minimizer_s *orig, *diff1;
		inf_double_s *pars;

		assert( pars = (inf_double_s *) malloc( thick_type_npars( position_from ) * sizeof( inf_double_s ) ) );

		orig = lenses_allocate( 2 );
		assert( orig );

		to_lens( orig->optics->lenses[0], 100, 300 );
		to_lens( orig->optics->lenses[1], 201, 0 );
		orig->optics->lenses[1]->thick_type = position_from;
		orig->optics->lenses[1]->thick_pars = pars;
		pars[0] = to_inf_double( -1 );
		pars[1] = to_inf_double( 401 );
		orig->optics->lenses[1]->feff_is_free = 1;
		orig->optics->lenses[1]->thick_is_free = 1;
		orig->star_obj = to_inf_double( 100 );
		orig->mf = NULL;
		orig->mf = mf_operand_add( orig->mf, "star_img", orig->star_obj, -1, mf_img, to_inf_double( 0 ), -1, 1, NULL );
		orig->mf = mf_operand_add( orig->mf, "star_mag", orig->star_obj, -1, mf_mag, to_inf_double( -2 ), -1, 1, NULL );
		orig->mf = mf_operand_add( orig->mf, "pupil_img", orig->pupil_obj, -1, mf_img, to_inf_inf( 1 ), -1, 1, NULL );
		assert( lenses_write( orig, "conffile_test.1.lens" ) == 0 );


		assert( lenses_write( orig, "conffile_test.3.lens" ) == 0 );
		badmf = merit_function( orig );
		goodmf = minimize( orig, 0, 1000, 10, 1e-10 );
		fprintf( stderr, "minimization result MF:%g\n", goodmf );
		assert( goodmf <= badmf );
		assert( lenses_write( orig, "conffile_test.4.lens" ) == 0 );

		assert( lenses_write( orig, "conffile_test.a.lens" ) == 0 );
		diff1 = lenses_read( "conffile_test.a.lens" );
		assert( diff1 );
		assert( lenses_write( diff1, "conffile_test.b.lens" ) == 0 );

		lenses_free( orig );
		lenses_free( diff1 );
	}

	/* complicated merit functions */
	{
		optics_minimizer_s *orig, *diff1;

		orig = lenses_read( "conffile_testoptics.txt" );
		assert( orig );
		assert( merit_function( orig ) < 1e-04 );

		assert( lenses_write( orig, "conffile_test.c.lens" ) == 0 );
		diff1 = lenses_read( "conffile_test.c.lens" );
		assert( lenses_write( diff1, "conffile_test.d.lens" ) == 0 );

		lenses_free( orig );
	}

	return EXIT_SUCCESS;
}
