/* conffile.h : configuration file I/O */

#ifndef CONFFILE_H
#define CONFFILE_H

static char *conffile_h_rcsid __attribute__((unused)) =
	"$Id: conffile.h,v 1.1.1.1 2004/10/27 20:14:07 tomono Exp $";

#include "optimize.h"

/* public functions */
int lenses_write( const optics_minimizer_s* optics, const char *path );	// writes the OPTICS into the file PATH.
	// displays errors and warnings to stderr, and returns the errno
	// or zero when there is no errors
	// set "-" as path to use stdout
optics_minimizer_s *lenses_allocate( const unsigned int nlens );	// alloctes memory for optics and initializes it
optics_minimizer_s *lenses_read( const char *path );	// reads the PATH and allocates and sets the optics.
	// displays errors and warnings to stderr, and returns
	// the pointer to the newly allocated optics
	// or NULL when an error occurred
	// set "-" as path to use stdin
void lenses_free( optics_minimizer_s* optics );	// free the memories allocated by lenses_read()
void lenses_file_usage( FILE *stream );	// shows how to write a conffile

/* local functions - they are here to be tested */

struct _words_s {
	char *word;
	struct _words_s *next;
};
typedef struct _words_s words_s;

words_s *word_get( const char *cptr, char **eptr );	// copies the first word at cptr. eptr points next to the end of the word.
words_s *value_get( const char *cptr, char **eptr );	// copies the first value or word at cptr. eptr points next to the end of the word or value
	// Returns null when no words found.
	// Otherwise, you have to free() the return value

words_s *words_s_scan( const char *line, const int mode, char **comment );	// scans for words(mode='w') or values(mode='v')
words_s *word_scan( const char *line, char **comment );	// scans words from a line, make a list, and returns the first words_s
	// comment points where the comment starts if there is, otherwise NULL
words_s *value_scan( const char *line );	// scans values from a line, make a list, and returns the first words_s
void word_free( words_s *words );	// free the memories allocated by word_scan or word_gets
size_t word_n( const words_s *words );	// count the number of words
words_s *word_next( const words_s *word );	// the next word
const char *word_the( const words_s *word );	// the word
const char *word_ith( const words_s *word, const size_t n );	// the n+1 th word

#endif	// CONFFILE_H
