/* points.h : header file for points.c */
/* Copyright (C) 2006 Daigo Tomono <tomono at subaru.naoj.org> */
/* Licensed under the terms of GPL2 or later */
#ifndef points_h
#define points_h

typedef struct {
	long a;	// number of allocated points
	long n;	// number of points
	double *x;	// x-coordinates of points
	double *y;	// y-coordinates of points
} points_s;

#define POINTS_DEF_ALLOC 16

/* memory management */
points_s *points_alloc(void);
void points_free(points_s *points);
points_s *points_append(points_s *points, double x, double y);

/* read ascii lines - xcol and ycol are 1-origin */
points_s *points_read(points_s *points, FILE* stream, long xcol, long ycol);

#endif	/* points_h */
