/* points.c : 2-dimensional points */
/* Copyright (C) 2006 Daigo Tomono <tomono at subaru.naoj.org> */
/* Licensed under the terms of GPL2 or later */

#include <stdio.h>
#include <stdlib.h>
#include <malloc.h>
#include <math.h>

#include "points.h"

#ifdef HAVE_CONFIG_H
	#include "config.h"
#endif

points_s *
points_alloc(void)
{
	points_s *result;
	result = (points_s *) malloc(sizeof(points_s));
	if (!result) return NULL;
	result->a = POINTS_DEF_ALLOC;
	result->n = 0;
	result->x = (double *) malloc(sizeof(double)*result->a);
	if (!result->x)
		{
			free(result);
			return NULL;
		}
	result->y = (double *) malloc(sizeof(double)*result->a);
	if (!result->y)
		{
			free(result->x);
			free(result);
			return NULL;
		}
	return result;
}

void
points_free(points_s *points)
{
	if (points->x) free(points->x);
	if (points->y) free(points->y);
	free(points);
}

points_s *
points_append(points_s *points, double x, double y)
{
	if (points->n + 1 >= points->a)
		{
			points->a *= 2;
			points->x = (double *) realloc(points->x, sizeof(double)*points->a);
			if (!points->x)
				{
					free(points->y);
					free(points);
					return NULL;
				}
			points->y = (double *) realloc(points->y, sizeof(double)*points->a);
			if (!points->y)
				{
					free(points->x);
					free(points);
					return NULL;
				}
		}
	points->x[points->n] = x;
	points->y[points->n] = y;
	points->n++;
	return points;
}

/* read ascii lines - xcol and ycol are 1-origin */
points_s *
points_read(points_s *points, FILE* stream, long xcol, long ycol)
{
	long state, nstates = 2;
	double xy[2];
	char buf[BUFSIZ], *ptr, *nptr;
	while(!feof(stream))
		{
			if (!fgets(buf, sizeof(buf), stream))
				{
					if (feof(stream)) break;
					return NULL;
				}
			if (buf[0] == '#') continue;

			ptr = buf;
			state = 0;
			while(state < nstates && ptr && *ptr)
				{
					xy[state] = strtod(ptr, &nptr);
					if (nptr > ptr) state++;
					ptr = nptr + 1;
				}

			if (state == nstates)
				{
					if (!points_append(points, xy[0], xy[1])) return NULL;
				}
			else
				{
					fprintf(stderr, "error reading the line: %s", buf);
				}
		}
	return points;
}

