/* fitting_test.c : test program for fitting.c */
/*
 * Copyright (C) 2003 Daigo Tomono <tomono at mpe.mpg.de>
 *
 * Permission is granted for use, copying, modification, distribution,
 * and distribution of modified versions of this work under the terms of
 * GPL version 2 or later.
 */
static char *rcsid __attribute__ ((unused)) =
	"$Id: fitting_test.c,v 1.1 2003/04/21 14:48:02 mos Exp $";

#include <stdio.h>
#include <stdlib.h>
#include "fitting.h"

#ifdef HAVE_CONFIG_H
	#include "config.h"
#endif

int
main( int argc, char * argv[])
{
	circle_s initial_circle, fitted_circle;
	fit_result_s fit_result;

	size_t npix = 6;
	double x[] = {-1,  0, 1, 0, 0, 0.707};
	double y[] = { 10, 9, 10, 11, 9, 10.707};

	{
		size_t i;
		for( i = 0; i < npix; i++ )
			{
				fprintf( stdout, "%2d: %7.2f,%7.2f\n", i, x[i], y[i] );
			}
	}

	guess_circle( &initial_circle, npix, x, y );

	fit_circle( &fitted_circle, &fit_result, &initial_circle, npix, x, y,
		100, 5, 5, 1e-10, 1e-10 );

	fprintf( stdout, "initial circle:\n  " );
	show_circle( &initial_circle, stdout );
	fprintf( stdout, "fitted circle:\n  " );
	show_circle( &fitted_circle, stdout );
	fprintf( stdout, "fitting:\n" );
	show_fit_result( &fit_result, stdout );

	return EXIT_SUCCESS;
}
