/* fitting.h : header file for fitting.h */
/*
 * Copyright (C) 2003 Daigo Tomono <tomono at mpe.mpg.de>
 *
 * Permission is granted for use, copying, modification, distribution,
 * and distribution of modified versions of this work under the terms of
 * GPL version 2 or later.
 */
#ifndef fitting_h
#define fitting_h

static char *fitting_h_rcsid __attribute__ ((unused)) =
	"$Id: fitting.h,v 1.5 2003/04/23 12:52:49 mos Exp $";

#include <stdlib.h>

#ifdef HAVE_CONFIG_H
#include "config.h"
#endif

/* error codes */
typedef enum {
	FIT_GOOD = 0,     	// no error : 0
	FIT_NOMEMORY,     	// out of memory
	FIT_TOO_MANY_ITER,	// too many iterations
	FIT_TOO_FEW_PIX,  	// too few pixels used for fitting
} fit_error_t;

/* data structures */
typedef struct {
	double x; 	// x-coordinate of the center
	double dx; 	// 1-sigma error bar
	double y; 	// y-coordinate of the center
	double dy;	// 1-sigma error bar
	double r; 	// radius
	double dr;	// 1-sigma error bar
} circle_s;

typedef struct {
	size_t iter;     	// number of iterations
	size_t n_used;   	// number of pixels used for fitting
	size_t n_changed;	// number of pixels changed usage in last iteration
	double chisq;    	// final chi-squared
	double sigma;    	// final sigma
	fit_error_t err; 	// error code
} fit_result_s;

/* functions */

char * fit_str_error( fit_error_t err );

/*
fit_circle() fits a circle onto a set of pixels which returns error
number.

outputs:
	fitted_circle: fitted circle
	fit_result:    final condition

inputs:
	npix:      number of pixels
	x, y:      coordinates of each pixel
	imax:      max iteration number
	sigma_rej: rejection criteria
	vf:        verbosity
 */
fit_error_t fit_circle(
	circle_s * fitted_circle, fit_result_s * fit_result,
	const circle_s * initial_circle,
	const size_t npix, const double x[], const double y[],
	const size_t imax, const double sigma_rej,
	const int vf, const double eps_abs, const double eps_rel );

void guess_circle( circle_s * guessed_circle,
	const size_t npix, const double x[], const double y[] );

/* display */
void show_circle( const circle_s * circle, FILE * stream );
void show_fit_result( const fit_result_s * result, FILE * stream );

#endif /* fitting_h */
