/* fits_test.c : test program for fits.c */
/*
 * Copyright (C) 2003 Daigo Tomono <tomono at mpe.mpg.de>
 *
 * Permission is granted for use, copying, modification, distribution,
 * and distribution of modified versions of this work under the terms of
 * GPL version 2 or later.
 */
static char *rcsid __attribute__ ((unused)) =
	"$Id: fits_test.c,v 1.4 2003/04/21 22:52:37 mos Exp $";

#include <stdio.h>
#include <stdlib.h>
#include <math.h>
#include <malloc.h>
#include <string.h>
#include <cfitsio/fitsio.h>

#include "fits.h"

#ifdef HAVE_CONFIG_H
	#include "config.h"
#endif

/* test program */
/* do something like:
	make && rm -f t.fits && ./fits_test test-fiber-image.fits t.fits 10000 0.2
 */
int
main( int argc, char *argv[])
{
	int status = 0;
	char *infilename, *outfilename;
	fitsfile *infits, *outfits;
	double threshold, ratio;
	boundary_pixels_s *pixels;
	boundary_pixel_s *curpixel;
	double one = 1;

	fprintf( stdout, "Test program for fits handling.\n  %s\n", rcsid );
	if( argc != 5 )
		{
			fprintf( stdout, "usage: %s in_fits out_fits threashold ratio\n",
				argv[0] );
			fputs( "you can try test-fiber-image.fits as an input file.\n",
				stdout );
			exit( EXIT_FAILURE );
		}

	/* command line options */
	infilename = argv[1];
	outfilename = argv[2];
	threshold = atof( argv[3] );
	ratio = atof( argv[4] );

	/* process */
	pixels = fits_boundary_pixels_new();
	if( pixels->err )
		{
			fputs( fits_boundary_str_error( pixels ), stdout );
			exit( EXIT_FAILURE );
		}

	fputs( "fits_open_file()\n", stdout );
	fits_open_file( &infits, infilename, READONLY, &status );
	if( status )
		{
			fits_report_error( stdout, status );
			exit( EXIT_FAILURE );
		}

	fputs( "fits_get_boundary_upper_pixels()\n", stdout );
	fits_get_boundary_upper_pixels( pixels, infits, threshold, ratio, 0 );
	if( pixels->err )
		{
			fputs( fits_boundary_str_error( pixels ), stdout );
			fputs( "\n", stdout );
			exit( EXIT_FAILURE );
		}

  fputs( "fits_create_file()\n", stdout );
	fits_create_file( &outfits, outfilename, &status );
	if( status )
		{
			fits_report_error( stdout, status );
			exit( EXIT_FAILURE );
		}

  fputs( "fits_copy_header()\n", stdout );
	fits_copy_header( infits, outfits, &status );
	if( status )
		{
			fits_report_error( stdout, status );
			exit( EXIT_FAILURE );
		}

  fputs( "setting values\n", stdout );
	curpixel = fits_boundary_pixels_first( pixels );
	do
		{
			fits_write_pix( outfits, TDOUBLE, curpixel->x, 1, &one, &status );
			show_pos( stdout, curpixel->x, curpixel->dim );
			fputs( " ", stdout );
			if( status )
				{
					fits_report_error( stdout, status );
					exit( EXIT_FAILURE );
				}
		} while( (curpixel = fits_boundary_pixels_next( curpixel ) ) != NULL );

  fputs( "\nfits_close_file()\n", stdout );
	fits_close_file( infits, &status );
	fits_close_file( outfits, &status );
	if( status )
		{
			fits_report_error( stdout, status );
			exit( EXIT_FAILURE );
		}

	fits_boundary_pixels_delete( pixels );
	return EXIT_SUCCESS;
}
